package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Vector implements Message {
    private int dimension;

    private List<Float> floatValues;

    private List<byte[]> binaryValues;

    private ValueType valueType;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, dimension, out);
        Writer.write(2, valueType, out);
        Writer.write(3, floatValues, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(4, binaryValues, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: dimension = Reader.readInt(input); hasValue = true; break;
                case 2: valueType = ValueType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: floatValues = Reader.readPack(input, Reader::readFloat); hasValue = true; break;
                case 4: binaryValues = Reader.readList(binaryValues, input, Reader::readBytes); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, dimension);
        size += SizeUtils.sizeOf(2, valueType);
        size += SizeUtils.sizeOfPack(3, floatValues, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(4, binaryValues, SizeUtils::sizeOf);
        return size;
    }
}
