package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TimeInfo implements Message {
    private long documentIndexWriteTimeNs;

    private long raftQueueWaitTimeNs;

    private long storeWriteTimeNs;

    private long totalRpcTimeNs;

    private long raftApplyTimeNs;

    private long raftCommitTimeNs;

    private long prepairCommitTimeNs;

    private long vectorIndexWriteTimeNs;

    private long serviceQueueWaitTimeNs;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, totalRpcTimeNs, out);
        Writer.write(2, serviceQueueWaitTimeNs, out);
        Writer.write(3, prepairCommitTimeNs, out);
        Writer.write(4, raftCommitTimeNs, out);
        Writer.write(5, raftQueueWaitTimeNs, out);
        Writer.write(6, raftApplyTimeNs, out);
        Writer.write(7, storeWriteTimeNs, out);
        Writer.write(8, vectorIndexWriteTimeNs, out);
        Writer.write(9, documentIndexWriteTimeNs, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: totalRpcTimeNs = Reader.readLong(input); hasValue = true; break;
                case 2: serviceQueueWaitTimeNs = Reader.readLong(input); hasValue = true; break;
                case 3: prepairCommitTimeNs = Reader.readLong(input); hasValue = true; break;
                case 4: raftCommitTimeNs = Reader.readLong(input); hasValue = true; break;
                case 5: raftQueueWaitTimeNs = Reader.readLong(input); hasValue = true; break;
                case 6: raftApplyTimeNs = Reader.readLong(input); hasValue = true; break;
                case 7: storeWriteTimeNs = Reader.readLong(input); hasValue = true; break;
                case 8: vectorIndexWriteTimeNs = Reader.readLong(input); hasValue = true; break;
                case 9: documentIndexWriteTimeNs = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, totalRpcTimeNs);
        size += SizeUtils.sizeOf(2, serviceQueueWaitTimeNs);
        size += SizeUtils.sizeOf(3, prepairCommitTimeNs);
        size += SizeUtils.sizeOf(4, raftCommitTimeNs);
        size += SizeUtils.sizeOf(5, raftQueueWaitTimeNs);
        size += SizeUtils.sizeOf(6, raftApplyTimeNs);
        size += SizeUtils.sizeOf(7, storeWriteTimeNs);
        size += SizeUtils.sizeOf(8, vectorIndexWriteTimeNs);
        size += SizeUtils.sizeOf(9, documentIndexWriteTimeNs);
        return size;
    }
}
