package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum StoreState implements Numeric {
    UNRECOGNIZED(-1),

    STORE_NEW(0),

    STORE_NORMAL(1),

    STORE_OFFLINE(2);

    public final Integer number;

    private Object ext$;

    private StoreState(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static StoreState forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return STORE_NEW;
            case 1: return STORE_NORMAL;
            case 2: return STORE_OFFLINE;
            default: return null;
        }
    }
}
