package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum StoreRegionState implements Numeric {
    UNRECOGNIZED(-1),

    NEW(0),

    NORMAL(1),

    STANDBY(2),

    SPLITTING(3),

    MERGING(4),

    DELETING(5),

    DELETED(6),

    ORPHAN(7),

    TOMBSTONE(8);

    public final Integer number;

    private Object ext$;

    private StoreRegionState(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static StoreRegionState forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return NEW;
            case 1: return NORMAL;
            case 2: return STANDBY;
            case 3: return SPLITTING;
            case 4: return MERGING;
            case 5: return DELETING;
            case 6: return DELETED;
            case 7: return ORPHAN;
            case 8: return TOMBSTONE;
            default: return null;
        }
    }
}
