package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class StoreOwnMetrics implements Message {
    private long systemTotalSwap;

    private long systemIoUtil;

    private long systemCpuUsage;

    private long systemFreeMemory;

    private long processUsedMemory;

    private boolean isReadyOnly;

    private long systemBufferMemory;

    private long systemFreeSwap;

    private long systemCachedMemory;

    private String readOnlyReason;

    private long systemAvailableMemory;

    private long systemTotalCapacity;

    private long id;

    private long systemSharedMemory;

    private long systemFreeCapacity;

    private long processUsedCpu;

    private long processUsedCapacity;

    private long systemTotalMemory;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, isReadyOnly, out);
        Writer.write(3, readOnlyReason, out);
        Writer.write(11, systemTotalCapacity, out);
        Writer.write(12, systemFreeCapacity, out);
        Writer.write(13, systemCpuUsage, out);
        Writer.write(14, systemTotalMemory, out);
        Writer.write(15, systemFreeMemory, out);
        Writer.write(16, systemSharedMemory, out);
        Writer.write(17, systemBufferMemory, out);
        Writer.write(18, systemCachedMemory, out);
        Writer.write(19, systemAvailableMemory, out);
        Writer.write(20, systemTotalSwap, out);
        Writer.write(21, systemFreeSwap, out);
        Writer.write(22, systemIoUtil, out);
        Writer.write(23, processUsedCpu, out);
        Writer.write(24, processUsedMemory, out);
        Writer.write(25, processUsedCapacity, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: isReadyOnly = Reader.readBoolean(input); hasValue = true; break;
                case 3: readOnlyReason = Reader.readString(input); hasValue = true; break;
                case 11: systemTotalCapacity = Reader.readLong(input); hasValue = true; break;
                case 12: systemFreeCapacity = Reader.readLong(input); hasValue = true; break;
                case 13: systemCpuUsage = Reader.readLong(input); hasValue = true; break;
                case 14: systemTotalMemory = Reader.readLong(input); hasValue = true; break;
                case 15: systemFreeMemory = Reader.readLong(input); hasValue = true; break;
                case 16: systemSharedMemory = Reader.readLong(input); hasValue = true; break;
                case 17: systemBufferMemory = Reader.readLong(input); hasValue = true; break;
                case 18: systemCachedMemory = Reader.readLong(input); hasValue = true; break;
                case 19: systemAvailableMemory = Reader.readLong(input); hasValue = true; break;
                case 20: systemTotalSwap = Reader.readLong(input); hasValue = true; break;
                case 21: systemFreeSwap = Reader.readLong(input); hasValue = true; break;
                case 22: systemIoUtil = Reader.readLong(input); hasValue = true; break;
                case 23: processUsedCpu = Reader.readLong(input); hasValue = true; break;
                case 24: processUsedMemory = Reader.readLong(input); hasValue = true; break;
                case 25: processUsedCapacity = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, isReadyOnly);
        size += SizeUtils.sizeOf(3, readOnlyReason);
        size += SizeUtils.sizeOf(11, systemTotalCapacity);
        size += SizeUtils.sizeOf(12, systemFreeCapacity);
        size += SizeUtils.sizeOf(13, systemCpuUsage);
        size += SizeUtils.sizeOf(14, systemTotalMemory);
        size += SizeUtils.sizeOf(15, systemFreeMemory);
        size += SizeUtils.sizeOf(16, systemSharedMemory);
        size += SizeUtils.sizeOf(17, systemBufferMemory);
        size += SizeUtils.sizeOf(18, systemCachedMemory);
        size += SizeUtils.sizeOf(19, systemAvailableMemory);
        size += SizeUtils.sizeOf(20, systemTotalSwap);
        size += SizeUtils.sizeOf(21, systemFreeSwap);
        size += SizeUtils.sizeOf(22, systemIoUtil);
        size += SizeUtils.sizeOf(23, processUsedCpu);
        size += SizeUtils.sizeOf(24, processUsedMemory);
        size += SizeUtils.sizeOf(25, processUsedCapacity);
        return size;
    }
}
