package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class StoreMetrics implements Message {
    private boolean isUpdateEpochVersion;

    private long id;

    private StoreOwnMetrics storeOwnMetrics;

    private boolean isPartialRegionMetrics;

    private Map<Long, RegionMetrics> regionMetricsMap;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(10, storeOwnMetrics, out);
        Writer.write(40, regionMetricsMap, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
        Writer.write(41, isPartialRegionMetrics, out);
        Writer.write(42, isUpdateEpochVersion, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 10: storeOwnMetrics = Reader.readMessage(new StoreOwnMetrics(), input); hasValue = hasValue ? hasValue : storeOwnMetrics != null; break;
                case 40: regionMetricsMap = Reader.readMap(number, regionMetricsMap, input, Reader::readLong, in -> Reader.readMessage(new RegionMetrics(), in)); hasValue = true; break;
                case 41: isPartialRegionMetrics = Reader.readBoolean(input); hasValue = true; break;
                case 42: isUpdateEpochVersion = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(10, storeOwnMetrics);
        size += SizeUtils.sizeOf(40, regionMetricsMap, SizeUtils::sizeOf, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(41, isPartialRegionMetrics);
        size += SizeUtils.sizeOf(42, isUpdateEpochVersion);
        return size;
    }
}
