package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Store implements Message {
    private StoreInState inState;

    private long createTimestamp;

    private Location serverLocation;

    private StoreState state;

    private long id;

    private String resourceTag;

    private Location raftLocation;

    private int leaderNumWeight;

    private long epoch;

    private String keyring;

    private StoreType storeType;

    private long lastSeenTimestamp;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, epoch, out);
        Writer.write(3, state, out);
        Writer.write(4, inState, out);
        Writer.write(5, serverLocation, out);
        Writer.write(6, raftLocation, out);
        Writer.write(7, resourceTag, out);
        Writer.write(8, keyring, out);
        Writer.write(9, createTimestamp, out);
        Writer.write(10, lastSeenTimestamp, out);
        Writer.write(11, storeType, out);
        Writer.write(20, leaderNumWeight, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: epoch = Reader.readLong(input); hasValue = true; break;
                case 3: state = StoreState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: inState = StoreInState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 5: serverLocation = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : serverLocation != null; break;
                case 6: raftLocation = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : raftLocation != null; break;
                case 7: resourceTag = Reader.readString(input); hasValue = true; break;
                case 8: keyring = Reader.readString(input); hasValue = true; break;
                case 9: createTimestamp = Reader.readLong(input); hasValue = true; break;
                case 10: lastSeenTimestamp = Reader.readLong(input); hasValue = true; break;
                case 11: storeType = StoreType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 20: leaderNumWeight = Reader.readInt(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, epoch);
        size += SizeUtils.sizeOf(3, state);
        size += SizeUtils.sizeOf(4, inState);
        size += SizeUtils.sizeOf(5, serverLocation);
        size += SizeUtils.sizeOf(6, raftLocation);
        size += SizeUtils.sizeOf(7, resourceTag);
        size += SizeUtils.sizeOf(8, keyring);
        size += SizeUtils.sizeOf(9, createTimestamp);
        size += SizeUtils.sizeOf(10, lastSeenTimestamp);
        size += SizeUtils.sizeOf(11, storeType);
        size += SizeUtils.sizeOf(20, leaderNumWeight);
        return size;
    }
}
