package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum StorageEngine implements Numeric {
    UNRECOGNIZED(-1),

    STORE_ENG_RAFT_STORE(0),

    STORE_ENG_MONO_STORE(1),

    STORE_ENG_MEMORY(2);

    public final Integer number;

    private Object ext$;

    private StorageEngine(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static StorageEngine forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return STORE_ENG_RAFT_STORE;
            case 1: return STORE_ENG_MONO_STORE;
            case 2: return STORE_ENG_MEMORY;
            default: return null;
        }
    }
}
