package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class StorageBackend implements Message {
    private BackendNest backend;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(backend, backend, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: backend = Reader.readMessage(new BackendNest.Noop(), input); hasValue = hasValue ? hasValue : backend != null; break;
                case 2: backend = Reader.readMessage(new BackendNest.Local(), input); hasValue = hasValue ? hasValue : backend != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(backend, backend);
        return size;
    }

    public interface BackendNest extends Message, Numeric {
        int number();

        Nest nest();

        @NoArgsConstructor
        @SuperBuilder
        class Noop extends io.dingodb.sdk.service.entity.common.Noop implements BackendNest {
            public static final int number = 1;

            @Override
            public int number() {
                return 1;
            }

            @Override
            public Nest nest() {
                return Nest.NOOP;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Local extends io.dingodb.sdk.service.entity.common.Local implements BackendNest {
            public static final int number = 2;

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.LOCAL;
            }
        }

        enum Nest implements Numeric {
            NOOP(1),

            LOCAL(2);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
