package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class StateDiskAnnParam implements Message {
    private DiskANNCoreState state;

    private DiskANNState diskannState;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, diskannState, out);
        Writer.write(2, state, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: diskannState = DiskANNState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: state = DiskANNCoreState.forNumber(Reader.readInt(input));hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, diskannState);
        size += SizeUtils.sizeOf(2, state);
        return size;
    }
}
