package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Schema implements Message {
    private boolean isKey;

    private String name;

    private int index;

    private boolean isNullable;

    private Type type;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, type, out);
        Writer.write(2, isKey, out);
        Writer.write(3, isNullable, out);
        Writer.write(4, index, out);
        Writer.write(5, name, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: type = Type.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: isKey = Reader.readBoolean(input); hasValue = true; break;
                case 3: isNullable = Reader.readBoolean(input); hasValue = true; break;
                case 4: index = Reader.readInt(input); hasValue = true; break;
                case 5: name = Reader.readString(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, type);
        size += SizeUtils.sizeOf(2, isKey);
        size += SizeUtils.sizeOf(3, isNullable);
        size += SizeUtils.sizeOf(4, index);
        size += SizeUtils.sizeOf(5, name);
        return size;
    }
}
