package io.dingodb.sdk.service.entity.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.SneakyThrows;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class ScalarField implements Message {
    private DataNest data;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(data, data, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: data = Reader.readMessage(new DataNest.BoolData(), input); hasValue = hasValue ? hasValue : data != null; break;
                case 2: data = Reader.readMessage(new DataNest.IntData(), input); hasValue = hasValue ? hasValue : data != null; break;
                case 3: data = Reader.readMessage(new DataNest.LongData(), input); hasValue = hasValue ? hasValue : data != null; break;
                case 4: data = Reader.readMessage(new DataNest.FloatData(), input); hasValue = hasValue ? hasValue : data != null; break;
                case 5: data = Reader.readMessage(new DataNest.DoubleData(), input); hasValue = hasValue ? hasValue : data != null; break;
                case 6: data = Reader.readMessage(new DataNest.StringData(), input); hasValue = hasValue ? hasValue : data != null; break;
                case 7: data = Reader.readMessage(new DataNest.BytesData(), input); hasValue = hasValue ? hasValue : data != null; break;
                case 8: data = Reader.readMessage(new DataNest.DatetimeData(), input); hasValue = hasValue ? hasValue : data != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(data, data);
        return size;
    }

    public interface DataNest extends Message, Numeric {
        int number();

        Nest nest();

        @AllArgsConstructor(
                staticName = "of"
        )
        @NoArgsConstructor
        @ToString
        class BoolData implements DataNest {
            public static final int number = 1;

            @Getter
            private boolean value;

            @Override
            @SneakyThrows
            public boolean read(CodedInputStream input) {
                value = Reader.readBoolean(input);
                return true;
            }

            @Override
            public void write(CodedOutputStream out) {
                Writer.write(number, value, out);
            }

            @Override
            public int sizeOf() {
                return SizeUtils.sizeOf(number, value);
            }

            @Override
            @JsonIgnore
            public boolean isDirect() {
                return true;
            }

            @Override
            public int number() {
                return 1;
            }

            @Override
            public Nest nest() {
                return Nest.BOOL_DATA;
            }
        }

        @AllArgsConstructor(
                staticName = "of"
        )
        @NoArgsConstructor
        @ToString
        class IntData implements DataNest {
            public static final int number = 2;

            @Getter
            private int value;

            @Override
            @SneakyThrows
            public boolean read(CodedInputStream input) {
                value = Reader.readInt(input);
                return true;
            }

            @Override
            public void write(CodedOutputStream out) {
                Writer.write(number, value, out);
            }

            @Override
            public int sizeOf() {
                return SizeUtils.sizeOf(number, value);
            }

            @Override
            @JsonIgnore
            public boolean isDirect() {
                return true;
            }

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.INT_DATA;
            }
        }

        @AllArgsConstructor(
                staticName = "of"
        )
        @NoArgsConstructor
        @ToString
        class LongData implements DataNest {
            public static final int number = 3;

            @Getter
            private long value;

            @Override
            @SneakyThrows
            public boolean read(CodedInputStream input) {
                value = Reader.readLong(input);
                return true;
            }

            @Override
            public void write(CodedOutputStream out) {
                Writer.write(number, value, out);
            }

            @Override
            public int sizeOf() {
                return SizeUtils.sizeOf(number, value);
            }

            @Override
            @JsonIgnore
            public boolean isDirect() {
                return true;
            }

            @Override
            public int number() {
                return 3;
            }

            @Override
            public Nest nest() {
                return Nest.LONG_DATA;
            }
        }

        @AllArgsConstructor(
                staticName = "of"
        )
        @NoArgsConstructor
        @ToString
        class FloatData implements DataNest {
            public static final int number = 4;

            @Getter
            private float value;

            @Override
            @SneakyThrows
            public boolean read(CodedInputStream input) {
                value = Reader.readFloat(input);
                return true;
            }

            @Override
            public void write(CodedOutputStream out) {
                Writer.write(number, value, out);
            }

            @Override
            public int sizeOf() {
                return SizeUtils.sizeOf(number, value);
            }

            @Override
            @JsonIgnore
            public boolean isDirect() {
                return true;
            }

            @Override
            public int number() {
                return 4;
            }

            @Override
            public Nest nest() {
                return Nest.FLOAT_DATA;
            }
        }

        @AllArgsConstructor(
                staticName = "of"
        )
        @NoArgsConstructor
        @ToString
        class DoubleData implements DataNest {
            public static final int number = 5;

            @Getter
            private double value;

            @Override
            @SneakyThrows
            public boolean read(CodedInputStream input) {
                value = Reader.readDouble(input);
                return true;
            }

            @Override
            public void write(CodedOutputStream out) {
                Writer.write(number, value, out);
            }

            @Override
            public int sizeOf() {
                return SizeUtils.sizeOf(number, value);
            }

            @Override
            @JsonIgnore
            public boolean isDirect() {
                return true;
            }

            @Override
            public int number() {
                return 5;
            }

            @Override
            public Nest nest() {
                return Nest.DOUBLE_DATA;
            }
        }

        @AllArgsConstructor(
                staticName = "of"
        )
        @NoArgsConstructor
        @ToString
        class StringData implements DataNest {
            public static final int number = 6;

            @Getter
            private String value;

            @Override
            @SneakyThrows
            public boolean read(CodedInputStream input) {
                value = Reader.readString(input);
                return true;
            }

            @Override
            public void write(CodedOutputStream out) {
                Writer.write(number, value, out);
            }

            @Override
            public int sizeOf() {
                return SizeUtils.sizeOf(number, value);
            }

            @Override
            @JsonIgnore
            public boolean isDirect() {
                return true;
            }

            @Override
            public int number() {
                return 6;
            }

            @Override
            public Nest nest() {
                return Nest.STRING_DATA;
            }
        }

        @AllArgsConstructor(
                staticName = "of"
        )
        @NoArgsConstructor
        @ToString
        class BytesData implements DataNest {
            public static final int number = 7;

            @Getter
            private byte[] value;

            @Override
            @SneakyThrows
            public boolean read(CodedInputStream input) {
                value = Reader.readBytes(input);
                return true;
            }

            @Override
            public void write(CodedOutputStream out) {
                Writer.write(number, value, out);
            }

            @Override
            public int sizeOf() {
                return SizeUtils.sizeOf(number, value);
            }

            @Override
            @JsonIgnore
            public boolean isDirect() {
                return true;
            }

            @JsonIgnore
            @ToString.Include
            public String valueHex$() {
                return io.dingodb.sdk.common.utils.ByteArrayUtils.toHex(value);
            }

            @Override
            public int number() {
                return 7;
            }

            @Override
            public Nest nest() {
                return Nest.BYTES_DATA;
            }
        }

        @AllArgsConstructor(
                staticName = "of"
        )
        @NoArgsConstructor
        @ToString
        class DatetimeData implements DataNest {
            public static final int number = 8;

            @Getter
            private String value;

            @Override
            @SneakyThrows
            public boolean read(CodedInputStream input) {
                value = Reader.readString(input);
                return true;
            }

            @Override
            public void write(CodedOutputStream out) {
                Writer.write(number, value, out);
            }

            @Override
            public int sizeOf() {
                return SizeUtils.sizeOf(number, value);
            }

            @Override
            @JsonIgnore
            public boolean isDirect() {
                return true;
            }

            @Override
            public int number() {
                return 8;
            }

            @Override
            public Nest nest() {
                return Nest.DATETIME_DATA;
            }
        }

        enum Nest implements Numeric {
            BOOL_DATA(1),

            INT_DATA(2),

            LONG_DATA(3),

            FLOAT_DATA(4),

            DOUBLE_DATA(5),

            STRING_DATA(6),

            BYTES_DATA(7),

            DATETIME_DATA(8);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
