package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum RegionType implements Numeric {
    UNRECOGNIZED(-1),

    STORE_REGION(0),

    INDEX_REGION(1),

    DOCUMENT_REGION(2);

    public final Integer number;

    private Object ext$;

    private RegionType(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static RegionType forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return STORE_REGION;
            case 1: return INDEX_REGION;
            case 2: return DOCUMENT_REGION;
            default: return null;
        }
    }
}
