package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RegionStatus implements Message {
    private long lastUpdateTimestamp;

    private RegionRaftStatus raftStatus;

    private RegionHeartbeatState heartbeatStatus;

    private ReplicaStatus replicaStatus;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, raftStatus, out);
        Writer.write(2, replicaStatus, out);
        Writer.write(3, heartbeatStatus, out);
        Writer.write(25, lastUpdateTimestamp, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: raftStatus = RegionRaftStatus.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: replicaStatus = ReplicaStatus.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: heartbeatStatus = RegionHeartbeatState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 25: lastUpdateTimestamp = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, raftStatus);
        size += SizeUtils.sizeOf(2, replicaStatus);
        size += SizeUtils.sizeOf(3, heartbeatStatus);
        size += SizeUtils.sizeOf(25, lastUpdateTimestamp);
        return size;
    }
}
