package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum RegionRaftStatus implements Numeric {
    UNRECOGNIZED(-1),

    REGION_RAFT_NONE(0),

    REGION_RAFT_HEALTHY(1),

    REGION_RAFT_LAGGY(3),

    REGION_RAFT_RECOVERING(4),

    REGION_RAFT_CONSECUTIVE_ERROR(5);

    public final Integer number;

    private Object ext$;

    private RegionRaftStatus(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static RegionRaftStatus forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return REGION_RAFT_NONE;
            case 1: return REGION_RAFT_HEALTHY;
            case 3: return REGION_RAFT_LAGGY;
            case 4: return REGION_RAFT_RECOVERING;
            case 5: return REGION_RAFT_CONSECUTIVE_ERROR;
            default: return null;
        }
    }
}
