package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RegionMetrics implements Message {
    private StoreRegionState storeRegionState;

    private long snapshotEpochVersion;

    private BRaftStatus braftStatus;

    private byte[] maxKey;

    private byte[] minKey;

    private RegionStatus regionStatus;

    private RegionDefinition regionDefinition;

    private long lastUpdateMetricsVersion;

    private long rowCount;

    private long lastUpdateMetricsLogIndex;

    private long lastUpdateMetricsTimestamp;

    private DocumentIndexMetrics documentIndexMetrics;

    private long leaderStoreId;

    private long id;

    private VectorIndexStatus vectorIndexStatus;

    private VectorIndexMetrics vectorIndexMetrics;

    private long regionSize;

    private DocumentIndexStatus documentIndexStatus;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, leaderStoreId, out);
        Writer.write(3, storeRegionState, out);
        Writer.write(4, braftStatus, out);
        Writer.write(5, regionDefinition, out);
        Writer.write(6, vectorIndexStatus, out);
        Writer.write(7, documentIndexStatus, out);
        Writer.write(11, rowCount, out);
        Writer.write(12, minKey, out);
        Writer.write(13, maxKey, out);
        Writer.write(14, regionSize, out);
        Writer.write(15, lastUpdateMetricsLogIndex, out);
        Writer.write(16, lastUpdateMetricsVersion, out);
        Writer.write(17, lastUpdateMetricsTimestamp, out);
        Writer.write(20, vectorIndexMetrics, out);
        Writer.write(21, snapshotEpochVersion, out);
        Writer.write(22, documentIndexMetrics, out);
        Writer.write(30, regionStatus, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: leaderStoreId = Reader.readLong(input); hasValue = true; break;
                case 3: storeRegionState = StoreRegionState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: braftStatus = Reader.readMessage(new BRaftStatus(), input); hasValue = hasValue ? hasValue : braftStatus != null; break;
                case 5: regionDefinition = Reader.readMessage(new RegionDefinition(), input); hasValue = hasValue ? hasValue : regionDefinition != null; break;
                case 6: vectorIndexStatus = Reader.readMessage(new VectorIndexStatus(), input); hasValue = hasValue ? hasValue : vectorIndexStatus != null; break;
                case 7: documentIndexStatus = Reader.readMessage(new DocumentIndexStatus(), input); hasValue = hasValue ? hasValue : documentIndexStatus != null; break;
                case 11: rowCount = Reader.readLong(input); hasValue = true; break;
                case 12: minKey = Reader.readBytes(input); hasValue = true; break;
                case 13: maxKey = Reader.readBytes(input); hasValue = true; break;
                case 14: regionSize = Reader.readLong(input); hasValue = true; break;
                case 15: lastUpdateMetricsLogIndex = Reader.readLong(input); hasValue = true; break;
                case 16: lastUpdateMetricsVersion = Reader.readLong(input); hasValue = true; break;
                case 17: lastUpdateMetricsTimestamp = Reader.readLong(input); hasValue = true; break;
                case 20: vectorIndexMetrics = Reader.readMessage(new VectorIndexMetrics(), input); hasValue = hasValue ? hasValue : vectorIndexMetrics != null; break;
                case 21: snapshotEpochVersion = Reader.readLong(input); hasValue = true; break;
                case 22: documentIndexMetrics = Reader.readMessage(new DocumentIndexMetrics(), input); hasValue = hasValue ? hasValue : documentIndexMetrics != null; break;
                case 30: regionStatus = Reader.readMessage(new RegionStatus(), input); hasValue = hasValue ? hasValue : regionStatus != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, leaderStoreId);
        size += SizeUtils.sizeOf(3, storeRegionState);
        size += SizeUtils.sizeOf(4, braftStatus);
        size += SizeUtils.sizeOf(5, regionDefinition);
        size += SizeUtils.sizeOf(6, vectorIndexStatus);
        size += SizeUtils.sizeOf(7, documentIndexStatus);
        size += SizeUtils.sizeOf(11, rowCount);
        size += SizeUtils.sizeOf(12, minKey);
        size += SizeUtils.sizeOf(13, maxKey);
        size += SizeUtils.sizeOf(14, regionSize);
        size += SizeUtils.sizeOf(15, lastUpdateMetricsLogIndex);
        size += SizeUtils.sizeOf(16, lastUpdateMetricsVersion);
        size += SizeUtils.sizeOf(17, lastUpdateMetricsTimestamp);
        size += SizeUtils.sizeOf(20, vectorIndexMetrics);
        size += SizeUtils.sizeOf(21, snapshotEpochVersion);
        size += SizeUtils.sizeOf(22, documentIndexMetrics);
        size += SizeUtils.sizeOf(30, regionStatus);
        return size;
    }
}
