package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum RegionHeartbeatState implements Numeric {
    UNRECOGNIZED(-1),

    REGION_ONLINE(0),

    REGION_DOWN(1);

    public final Integer number;

    private Object ext$;

    private RegionHeartbeatState(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static RegionHeartbeatState forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return REGION_ONLINE;
            case 1: return REGION_DOWN;
            default: return null;
        }
    }
}
