package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RegionDefinition implements Message {
    private StorageEngine storeEngine;

    private long tenantId;

    private long partId;

    private String name;

    private RegionEpoch epoch;

    private long tableId;

    private long schemaId;

    private long id;

    private IndexParameter indexParameter;

    private long indexId;

    private long revision;

    private Range range;

    private List<Peer> peers;

    private RawEngine rawEngine;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, epoch, out);
        Writer.write(3, name, out);
        Writer.write(4, peers, (n, v) -> Writer.write(n, v, out));
        Writer.write(5, range, out);
        Writer.write(6, rawEngine, out);
        Writer.write(7, storeEngine, out);
        Writer.write(11, schemaId, out);
        Writer.write(12, tableId, out);
        Writer.write(13, indexId, out);
        Writer.write(14, partId, out);
        Writer.write(15, tenantId, out);
        Writer.write(20, indexParameter, out);
        Writer.write(50, revision, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: epoch = Reader.readMessage(new RegionEpoch(), input); hasValue = hasValue ? hasValue : epoch != null; break;
                case 3: name = Reader.readString(input); hasValue = true; break;
                case 4: peers = Reader.readList(peers, input, in -> Reader.readMessage(new Peer(), in)); hasValue = true; break;
                case 5: range = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 6: rawEngine = RawEngine.forNumber(Reader.readInt(input));hasValue = true; break;
                case 7: storeEngine = StorageEngine.forNumber(Reader.readInt(input));hasValue = true; break;
                case 11: schemaId = Reader.readLong(input); hasValue = true; break;
                case 12: tableId = Reader.readLong(input); hasValue = true; break;
                case 13: indexId = Reader.readLong(input); hasValue = true; break;
                case 14: partId = Reader.readLong(input); hasValue = true; break;
                case 15: tenantId = Reader.readLong(input); hasValue = true; break;
                case 20: indexParameter = Reader.readMessage(new IndexParameter(), input); hasValue = hasValue ? hasValue : indexParameter != null; break;
                case 50: revision = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, epoch);
        size += SizeUtils.sizeOf(3, name);
        size += SizeUtils.sizeOf(4, peers, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, range);
        size += SizeUtils.sizeOf(6, rawEngine);
        size += SizeUtils.sizeOf(7, storeEngine);
        size += SizeUtils.sizeOf(11, schemaId);
        size += SizeUtils.sizeOf(12, tableId);
        size += SizeUtils.sizeOf(13, indexId);
        size += SizeUtils.sizeOf(14, partId);
        size += SizeUtils.sizeOf(15, tenantId);
        size += SizeUtils.sizeOf(20, indexParameter);
        size += SizeUtils.sizeOf(50, revision);
        return size;
    }
}
