package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Region implements Message {
    private long createTimestamp;

    private long leaderStoreId;

    private RegionState state;

    private long id;

    private long epoch;

    private RegionStatus status;

    private RegionType regionType;

    private RegionMetrics metrics;

    private RegionDefinition definition;

    private long deletedTimestamp;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, epoch, out);
        Writer.write(3, regionType, out);
        Writer.write(4, definition, out);
        Writer.write(10, state, out);
        Writer.write(11, status, out);
        Writer.write(12, leaderStoreId, out);
        Writer.write(20, metrics, out);
        Writer.write(21, createTimestamp, out);
        Writer.write(22, deletedTimestamp, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: epoch = Reader.readLong(input); hasValue = true; break;
                case 3: regionType = RegionType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: definition = Reader.readMessage(new RegionDefinition(), input); hasValue = hasValue ? hasValue : definition != null; break;
                case 10: state = RegionState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 11: status = Reader.readMessage(new RegionStatus(), input); hasValue = hasValue ? hasValue : status != null; break;
                case 12: leaderStoreId = Reader.readLong(input); hasValue = true; break;
                case 20: metrics = Reader.readMessage(new RegionMetrics(), input); hasValue = hasValue ? hasValue : metrics != null; break;
                case 21: createTimestamp = Reader.readLong(input); hasValue = true; break;
                case 22: deletedTimestamp = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, epoch);
        size += SizeUtils.sizeOf(3, regionType);
        size += SizeUtils.sizeOf(4, definition);
        size += SizeUtils.sizeOf(10, state);
        size += SizeUtils.sizeOf(11, status);
        size += SizeUtils.sizeOf(12, leaderStoreId);
        size += SizeUtils.sizeOf(20, metrics);
        size += SizeUtils.sizeOf(21, createTimestamp);
        size += SizeUtils.sizeOf(22, deletedTimestamp);
        return size;
    }
}
