package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum RawEngine implements Numeric {
    UNRECOGNIZED(-1),

    RAW_ENG_ROCKSDB(0),

    RAW_ENG_BDB(1),

    RAW_ENG_XDPROCKS(2);

    public final Integer number;

    private Object ext$;

    private RawEngine(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static RawEngine forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return RAW_ENG_ROCKSDB;
            case 1: return RAW_ENG_BDB;
            case 2: return RAW_ENG_XDPROCKS;
            default: return null;
        }
    }
}
