package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RangeWithOptions implements Message {
    private boolean withEnd;

    private Range range;

    private boolean withStart;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, range, out);
        Writer.write(2, withStart, out);
        Writer.write(3, withEnd, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: range = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 2: withStart = Reader.readBoolean(input); hasValue = true; break;
                case 3: withEnd = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, range);
        size += SizeUtils.sizeOf(2, withStart);
        size += SizeUtils.sizeOf(3, withEnd);
        return size;
    }
}
