package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RaftPeerStatus implements Message {
    private long lastRpcSendTimestamp;

    private boolean valid;

    private boolean installingSnapshot;

    private long flyingAppendEntriesSize;

    private long nextIndex;

    private int consecutiveErrorTimes;

    private long readonlyIndex;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, valid, out);
        Writer.write(2, installingSnapshot, out);
        Writer.write(3, nextIndex, out);
        Writer.write(4, lastRpcSendTimestamp, out);
        Writer.write(5, flyingAppendEntriesSize, out);
        Writer.write(6, readonlyIndex, out);
        Writer.write(7, consecutiveErrorTimes, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: valid = Reader.readBoolean(input); hasValue = true; break;
                case 2: installingSnapshot = Reader.readBoolean(input); hasValue = true; break;
                case 3: nextIndex = Reader.readLong(input); hasValue = true; break;
                case 4: lastRpcSendTimestamp = Reader.readLong(input); hasValue = true; break;
                case 5: flyingAppendEntriesSize = Reader.readLong(input); hasValue = true; break;
                case 6: readonlyIndex = Reader.readLong(input); hasValue = true; break;
                case 7: consecutiveErrorTimes = Reader.readInt(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, valid);
        size += SizeUtils.sizeOf(2, installingSnapshot);
        size += SizeUtils.sizeOf(3, nextIndex);
        size += SizeUtils.sizeOf(4, lastRpcSendTimestamp);
        size += SizeUtils.sizeOf(5, flyingAppendEntriesSize);
        size += SizeUtils.sizeOf(6, readonlyIndex);
        size += SizeUtils.sizeOf(7, consecutiveErrorTimes);
        return size;
    }
}
