package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum RaftNodeState implements Numeric {
    UNRECOGNIZED(-1),

    STATE_NONE(0),

    STATE_LEADER(1),

    STATE_TRANSFERRING(2),

    STATE_CANDIDATE(3),

    STATE_FOLLOWER(4),

    STATE_ERROR(5),

    STATE_UNINITIALIZED(6),

    STATE_SHUTTING(7),

    STATE_SHUTDOWN(8),

    STATE_END(9);

    public final Integer number;

    private Object ext$;

    private RaftNodeState(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static RaftNodeState forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return STATE_NONE;
            case 1: return STATE_LEADER;
            case 2: return STATE_TRANSFERRING;
            case 3: return STATE_CANDIDATE;
            case 4: return STATE_FOLLOWER;
            case 5: return STATE_ERROR;
            case 6: return STATE_UNINITIALIZED;
            case 7: return STATE_SHUTTING;
            case 8: return STATE_SHUTDOWN;
            case 9: return STATE_END;
            default: return null;
        }
    }
}
