package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum PeerRole implements Numeric {
    UNRECOGNIZED(-1),

    VOTER(0),

    LEARNER(1);

    public final Integer number;

    private Object ext$;

    private PeerRole(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static PeerRole forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return VOTER;
            case 1: return LEARNER;
            default: return null;
        }
    }
}
