package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum MetricType implements Numeric {
    UNRECOGNIZED(-1),

    METRIC_TYPE_NONE(0),

    METRIC_TYPE_L2(1),

    METRIC_TYPE_INNER_PRODUCT(2),

    METRIC_TYPE_COSINE(3),

    METRIC_TYPE_HAMMING(4);

    public final Integer number;

    private Object ext$;

    private MetricType(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static MetricType forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return METRIC_TYPE_NONE;
            case 1: return METRIC_TYPE_L2;
            case 2: return METRIC_TYPE_INNER_PRODUCT;
            case 3: return METRIC_TYPE_COSINE;
            case 4: return METRIC_TYPE_HAMMING;
            default: return null;
        }
    }
}
