package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class MDS implements Message {
    private OnlineState onlineState;

    private long lastOnlineTimeMs;

    private State state;

    private long id;

    private long registerTimeMs;

    private Location location;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, location, out);
        Writer.write(3, onlineState, out);
        Writer.write(4, state, out);
        Writer.write(10, registerTimeMs, out);
        Writer.write(11, lastOnlineTimeMs, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: location = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : location != null; break;
                case 3: onlineState = OnlineState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: state = State.forNumber(Reader.readInt(input));hasValue = true; break;
                case 10: registerTimeMs = Reader.readLong(input); hasValue = true; break;
                case 11: lastOnlineTimeMs = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, location);
        size += SizeUtils.sizeOf(3, onlineState);
        size += SizeUtils.sizeOf(4, state);
        size += SizeUtils.sizeOf(10, registerTimeMs);
        size += SizeUtils.sizeOf(11, lastOnlineTimeMs);
        return size;
    }
}
