package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class IndexParameter implements Message {
    private ScalarIndexParameter scalarIndexParameter;

    private DocumentIndexParameter documentIndexParameter;

    private List<String> originWithKeys;

    private List<String> originKeys;

    private IndexType indexType;

    private VectorIndexParameter vectorIndexParameter;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, indexType, out);
        Writer.write(2, vectorIndexParameter, out);
        Writer.write(3, scalarIndexParameter, out);
        Writer.write(4, documentIndexParameter, out);
        Writer.write(5, originKeys, (n, v) -> Writer.write(n, v, out));
        Writer.write(6, originWithKeys, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: indexType = IndexType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: vectorIndexParameter = Reader.readMessage(new VectorIndexParameter(), input); hasValue = hasValue ? hasValue : vectorIndexParameter != null; break;
                case 3: scalarIndexParameter = Reader.readMessage(new ScalarIndexParameter(), input); hasValue = hasValue ? hasValue : scalarIndexParameter != null; break;
                case 4: documentIndexParameter = Reader.readMessage(new DocumentIndexParameter(), input); hasValue = hasValue ? hasValue : documentIndexParameter != null; break;
                case 5: originKeys = Reader.readList(originKeys, input, Reader::readString); hasValue = true; break;
                case 6: originWithKeys = Reader.readList(originWithKeys, input, Reader::readString); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, indexType);
        size += SizeUtils.sizeOf(2, vectorIndexParameter);
        size += SizeUtils.sizeOf(3, scalarIndexParameter);
        size += SizeUtils.sizeOf(4, documentIndexParameter);
        size += SizeUtils.sizeOf(5, originKeys, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(6, originWithKeys, SizeUtils::sizeOf);
        return size;
    }
}
