package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Executor implements Message {
    private String leaderId;

    private String clusterName;

    private long createTimestamp;

    private Location serverLocation;

    private ExecutorState state;

    private String id;

    private String resourceTag;

    private long epoch;

    private ExecutorUser executorUser;

    private long lastSeenTimestamp;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, epoch, out);
        Writer.write(3, state, out);
        Writer.write(4, serverLocation, out);
        Writer.write(5, executorUser, out);
        Writer.write(6, resourceTag, out);
        Writer.write(7, createTimestamp, out);
        Writer.write(8, lastSeenTimestamp, out);
        Writer.write(9, clusterName, out);
        Writer.write(10, leaderId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readString(input); hasValue = true; break;
                case 2: epoch = Reader.readLong(input); hasValue = true; break;
                case 3: state = ExecutorState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: serverLocation = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : serverLocation != null; break;
                case 5: executorUser = Reader.readMessage(new ExecutorUser(), input); hasValue = hasValue ? hasValue : executorUser != null; break;
                case 6: resourceTag = Reader.readString(input); hasValue = true; break;
                case 7: createTimestamp = Reader.readLong(input); hasValue = true; break;
                case 8: lastSeenTimestamp = Reader.readLong(input); hasValue = true; break;
                case 9: clusterName = Reader.readString(input); hasValue = true; break;
                case 10: leaderId = Reader.readString(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, epoch);
        size += SizeUtils.sizeOf(3, state);
        size += SizeUtils.sizeOf(4, serverLocation);
        size += SizeUtils.sizeOf(5, executorUser);
        size += SizeUtils.sizeOf(6, resourceTag);
        size += SizeUtils.sizeOf(7, createTimestamp);
        size += SizeUtils.sizeOf(8, lastSeenTimestamp);
        size += SizeUtils.sizeOf(9, clusterName);
        size += SizeUtils.sizeOf(10, leaderId);
        return size;
    }
}
