package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum Engine implements Numeric {
    UNRECOGNIZED(-1),

    ENG_ROCKSDB(0),

    ENG_BDB(1),

    LSM(2),

    TXN_LSM(3),

    BTREE(4),

    TXN_BTREE(5);

    public final Integer number;

    private Object ext$;

    private Engine(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static Engine forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return ENG_ROCKSDB;
            case 1: return ENG_BDB;
            case 2: return LSM;
            case 3: return TXN_LSM;
            case 4: return BTREE;
            case 5: return TXN_BTREE;
            default: return null;
        }
    }
}
