package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DocumentValue implements Message {
    private ScalarFieldType fieldType;

    private ScalarField fieldValue;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, fieldType, out);
        Writer.write(2, fieldValue, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: fieldType = ScalarFieldType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: fieldValue = Reader.readMessage(new ScalarField(), input); hasValue = hasValue ? hasValue : fieldValue != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, fieldType);
        size += SizeUtils.sizeOf(2, fieldValue);
        return size;
    }
}
