package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DocumentSearchParameter implements Message {
    private List<String> columnNames;

    private List<String> selectedKeys;

    private boolean useIdFilter;

    private boolean withoutTableData;

    private List<Long> documentIds;

    private boolean queryUnlimited;

    private String queryString;

    private boolean withoutScalarData;

    private int topN;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, topN, out);
        Writer.write(2, queryString, out);
        Writer.write(3, useIdFilter, out);
        Writer.write(4, documentIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(5, columnNames, (n, v) -> Writer.write(n, v, out));
        Writer.write(10, withoutScalarData, out);
        Writer.write(11, selectedKeys, (n, v) -> Writer.write(n, v, out));
        Writer.write(12, withoutTableData, out);
        Writer.write(13, queryUnlimited, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: topN = Reader.readInt(input); hasValue = true; break;
                case 2: queryString = Reader.readString(input); hasValue = true; break;
                case 3: useIdFilter = Reader.readBoolean(input); hasValue = true; break;
                case 4: documentIds = Reader.readPack(input, Reader::readLong); hasValue = true; break;
                case 5: columnNames = Reader.readList(columnNames, input, Reader::readString); hasValue = true; break;
                case 10: withoutScalarData = Reader.readBoolean(input); hasValue = true; break;
                case 11: selectedKeys = Reader.readList(selectedKeys, input, Reader::readString); hasValue = true; break;
                case 12: withoutTableData = Reader.readBoolean(input); hasValue = true; break;
                case 13: queryUnlimited = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, topN);
        size += SizeUtils.sizeOf(2, queryString);
        size += SizeUtils.sizeOf(3, useIdFilter);
        size += SizeUtils.sizeOfPack(4, documentIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, columnNames, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(10, withoutScalarData);
        size += SizeUtils.sizeOf(11, selectedKeys, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(12, withoutTableData);
        size += SizeUtils.sizeOf(13, queryUnlimited);
        return size;
    }
}
