package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DocumentIndexStatus implements Message {
    private boolean isBuildError;

    private boolean isReady;

    private boolean isOwnReady;

    private long snapshotLogId;

    private boolean isHoldDocumentIndex;

    private long applyLogId;

    private boolean isRebuildError;

    private boolean isStop;

    private long lastBuildEpochVersion;

    private boolean isSwitching;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, isStop, out);
        Writer.write(2, isReady, out);
        Writer.write(3, isOwnReady, out);
        Writer.write(4, isBuildError, out);
        Writer.write(5, isRebuildError, out);
        Writer.write(6, isSwitching, out);
        Writer.write(7, isHoldDocumentIndex, out);
        Writer.write(8, applyLogId, out);
        Writer.write(9, snapshotLogId, out);
        Writer.write(10, lastBuildEpochVersion, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: isStop = Reader.readBoolean(input); hasValue = true; break;
                case 2: isReady = Reader.readBoolean(input); hasValue = true; break;
                case 3: isOwnReady = Reader.readBoolean(input); hasValue = true; break;
                case 4: isBuildError = Reader.readBoolean(input); hasValue = true; break;
                case 5: isRebuildError = Reader.readBoolean(input); hasValue = true; break;
                case 6: isSwitching = Reader.readBoolean(input); hasValue = true; break;
                case 7: isHoldDocumentIndex = Reader.readBoolean(input); hasValue = true; break;
                case 8: applyLogId = Reader.readLong(input); hasValue = true; break;
                case 9: snapshotLogId = Reader.readLong(input); hasValue = true; break;
                case 10: lastBuildEpochVersion = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, isStop);
        size += SizeUtils.sizeOf(2, isReady);
        size += SizeUtils.sizeOf(3, isOwnReady);
        size += SizeUtils.sizeOf(4, isBuildError);
        size += SizeUtils.sizeOf(5, isRebuildError);
        size += SizeUtils.sizeOf(6, isSwitching);
        size += SizeUtils.sizeOf(7, isHoldDocumentIndex);
        size += SizeUtils.sizeOf(8, applyLogId);
        size += SizeUtils.sizeOf(9, snapshotLogId);
        size += SizeUtils.sizeOf(10, lastBuildEpochVersion);
        return size;
    }
}
