package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DocumentIndexMetrics implements Message {
    private long totalNumDocs;

    private long minId;

    private long maxId;

    private long totalNumTokens;

    private String metaJson;

    private String jsonParameter;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, totalNumDocs, out);
        Writer.write(2, totalNumTokens, out);
        Writer.write(3, maxId, out);
        Writer.write(4, minId, out);
        Writer.write(5, metaJson, out);
        Writer.write(6, jsonParameter, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: totalNumDocs = Reader.readLong(input); hasValue = true; break;
                case 2: totalNumTokens = Reader.readLong(input); hasValue = true; break;
                case 3: maxId = Reader.readLong(input); hasValue = true; break;
                case 4: minId = Reader.readLong(input); hasValue = true; break;
                case 5: metaJson = Reader.readString(input); hasValue = true; break;
                case 6: jsonParameter = Reader.readString(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, totalNumDocs);
        size += SizeUtils.sizeOf(2, totalNumTokens);
        size += SizeUtils.sizeOf(3, maxId);
        size += SizeUtils.sizeOf(4, minId);
        size += SizeUtils.sizeOf(5, metaJson);
        size += SizeUtils.sizeOf(6, jsonParameter);
        return size;
    }
}
