package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Document implements Message {
    private TableData tableData;

    private Map<String, DocumentValue> documentData;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, documentData, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
        Writer.write(2, tableData, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: documentData = Reader.readMap(number, documentData, input, Reader::readString, in -> Reader.readMessage(new DocumentValue(), in)); hasValue = true; break;
                case 2: tableData = Reader.readMessage(new TableData(), input); hasValue = hasValue ? hasValue : tableData != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, documentData, SizeUtils::sizeOf, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(2, tableData);
        return size;
    }
}
