package io.dingodb.sdk.service.entity.common;

import io.dingodb.sdk.service.entity.Numeric;

public enum DiskANNCoreState implements Numeric {
    UNRECOGNIZED(-1),

    UNKNOWN(0),

    IMPORTING(1),

    IMPORTED(2),

    UNINITIALIZED(3),

    INITIALIZED(4),

    BUILDING(5),

    BUILDED(6),

    UPDATINGPATH(7),

    UPDATEDPATH(8),

    LOADING(9),

    LOADED(10),

    SEARCHING(11),

    SEARCHED(12),

    RESETING(13),

    RESET(14),

    DESTROYING(15),

    DESTROYED(16),

    IDLE(17),

    FAILED(18),

    FAKEBUILDED(19),

    NODATA(20);

    public final Integer number;

    private Object ext$;

    private DiskANNCoreState(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static DiskANNCoreState forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return UNKNOWN;
            case 1: return IMPORTING;
            case 2: return IMPORTED;
            case 3: return UNINITIALIZED;
            case 4: return INITIALIZED;
            case 5: return BUILDING;
            case 6: return BUILDED;
            case 7: return UPDATINGPATH;
            case 8: return UPDATEDPATH;
            case 9: return LOADING;
            case 10: return LOADED;
            case 11: return SEARCHING;
            case 12: return SEARCHED;
            case 13: return RESETING;
            case 14: return RESET;
            case 15: return DESTROYING;
            case 16: return DESTROYED;
            case 17: return IDLE;
            case 18: return FAILED;
            case 19: return FAKEBUILDED;
            case 20: return NODATA;
            default: return null;
        }
    }
}
