package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CreateIvfPqParam implements Message {
    private int bucketMaxSize;

    private int dimension;

    private int nbitsPerIdx;

    private int bucketInitSize;

    private MetricType metricType;

    private int ncentroids;

    private int nsubvector;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, dimension, out);
        Writer.write(2, metricType, out);
        Writer.write(3, ncentroids, out);
        Writer.write(4, nsubvector, out);
        Writer.write(5, bucketInitSize, out);
        Writer.write(6, bucketMaxSize, out);
        Writer.write(7, nbitsPerIdx, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: dimension = Reader.readInt(input); hasValue = true; break;
                case 2: metricType = MetricType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: ncentroids = Reader.readInt(input); hasValue = true; break;
                case 4: nsubvector = Reader.readInt(input); hasValue = true; break;
                case 5: bucketInitSize = Reader.readInt(input); hasValue = true; break;
                case 6: bucketMaxSize = Reader.readInt(input); hasValue = true; break;
                case 7: nbitsPerIdx = Reader.readInt(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, dimension);
        size += SizeUtils.sizeOf(2, metricType);
        size += SizeUtils.sizeOf(3, ncentroids);
        size += SizeUtils.sizeOf(4, nsubvector);
        size += SizeUtils.sizeOf(5, bucketInitSize);
        size += SizeUtils.sizeOf(6, bucketMaxSize);
        size += SizeUtils.sizeOf(7, nbitsPerIdx);
        return size;
    }
}
