package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CreateDiskAnnParam implements Message {
    private int dimension;

    private int buildPqBytes;

    private int maxDegree;

    private int qd;

    private int pqDiskBytes;

    private ValueType valueType;

    private MetricType metricType;

    private boolean appendReorderData;

    private int searchListSize;

    private String codebookPrefix;

    private boolean useOpq;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, dimension, out);
        Writer.write(2, metricType, out);
        Writer.write(3, valueType, out);
        Writer.write(4, maxDegree, out);
        Writer.write(5, searchListSize, out);
        Writer.write(6, qd, out);
        Writer.write(7, codebookPrefix, out);
        Writer.write(8, pqDiskBytes, out);
        Writer.write(9, appendReorderData, out);
        Writer.write(10, buildPqBytes, out);
        Writer.write(11, useOpq, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: dimension = Reader.readInt(input); hasValue = true; break;
                case 2: metricType = MetricType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: valueType = ValueType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: maxDegree = Reader.readInt(input); hasValue = true; break;
                case 5: searchListSize = Reader.readInt(input); hasValue = true; break;
                case 6: qd = Reader.readInt(input); hasValue = true; break;
                case 7: codebookPrefix = Reader.readString(input); hasValue = true; break;
                case 8: pqDiskBytes = Reader.readInt(input); hasValue = true; break;
                case 9: appendReorderData = Reader.readBoolean(input); hasValue = true; break;
                case 10: buildPqBytes = Reader.readInt(input); hasValue = true; break;
                case 11: useOpq = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, dimension);
        size += SizeUtils.sizeOf(2, metricType);
        size += SizeUtils.sizeOf(3, valueType);
        size += SizeUtils.sizeOf(4, maxDegree);
        size += SizeUtils.sizeOf(5, searchListSize);
        size += SizeUtils.sizeOf(6, qd);
        size += SizeUtils.sizeOf(7, codebookPrefix);
        size += SizeUtils.sizeOf(8, pqDiskBytes);
        size += SizeUtils.sizeOf(9, appendReorderData);
        size += SizeUtils.sizeOf(10, buildPqBytes);
        size += SizeUtils.sizeOf(11, useOpq);
        return size;
    }
}
