package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CreateBinaryFlatParam implements Message {
    private int dimension;

    private MetricType metricType;

    private boolean useApproximateTopK;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, dimension, out);
        Writer.write(2, metricType, out);
        Writer.write(3, useApproximateTopK, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: dimension = Reader.readInt(input); hasValue = true; break;
                case 2: metricType = MetricType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: useApproximateTopK = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, dimension);
        size += SizeUtils.sizeOf(2, metricType);
        size += SizeUtils.sizeOf(3, useApproximateTopK);
        return size;
    }
}
