package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CoprocessorV2 implements Message {
    private byte[] relExpr;

    private List<Integer> selectionColumns;

    private SchemaWrapper resultSchema;

    private boolean forAggCount;

    private int schemaVersion;

    private SchemaWrapper originalSchema;

    private int codecVersion;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, schemaVersion, out);
        Writer.write(2, originalSchema, out);
        Writer.write(3, resultSchema, out);
        Writer.write(4, selectionColumns, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(5, relExpr, out);
        Writer.write(6, codecVersion, out);
        Writer.write(7, forAggCount, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: schemaVersion = Reader.readInt(input); hasValue = true; break;
                case 2: originalSchema = Reader.readMessage(new SchemaWrapper(), input); hasValue = hasValue ? hasValue : originalSchema != null; break;
                case 3: resultSchema = Reader.readMessage(new SchemaWrapper(), input); hasValue = hasValue ? hasValue : resultSchema != null; break;
                case 4: selectionColumns = Reader.readPack(input, Reader::readInt); hasValue = true; break;
                case 5: relExpr = Reader.readBytes(input); hasValue = true; break;
                case 6: codecVersion = Reader.readInt(input); hasValue = true; break;
                case 7: forAggCount = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, schemaVersion);
        size += SizeUtils.sizeOf(2, originalSchema);
        size += SizeUtils.sizeOf(3, resultSchema);
        size += SizeUtils.sizeOfPack(4, selectionColumns, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, relExpr);
        size += SizeUtils.sizeOf(6, codecVersion);
        size += SizeUtils.sizeOf(7, forAggCount);
        return size;
    }
}
