package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class ControlConfigVariable implements Message {
    private String name;

    private boolean isErrorOccurred;

    private boolean isAlreadySet;

    private String value;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, name, out);
        Writer.write(2, value, out);
        Writer.write(3, isAlreadySet, out);
        Writer.write(4, isErrorOccurred, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: name = Reader.readString(input); hasValue = true; break;
                case 2: value = Reader.readString(input); hasValue = true; break;
                case 3: isAlreadySet = Reader.readBoolean(input); hasValue = true; break;
                case 4: isErrorOccurred = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, name);
        size += SizeUtils.sizeOf(2, value);
        size += SizeUtils.sizeOf(3, isAlreadySet);
        size += SizeUtils.sizeOf(4, isErrorOccurred);
        return size;
    }
}
