package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class BackupDataFileValueSstMeta implements Message {
    private String fileName;

    private String encryption;

    private long fileSize;

    private String dirName;

    private String cf;

    private long regionId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, cf, out);
        Writer.write(2, regionId, out);
        Writer.write(3, dirName, out);
        Writer.write(4, fileSize, out);
        Writer.write(5, encryption, out);
        Writer.write(6, fileName, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: cf = Reader.readString(input); hasValue = true; break;
                case 2: regionId = Reader.readLong(input); hasValue = true; break;
                case 3: dirName = Reader.readString(input); hasValue = true; break;
                case 4: fileSize = Reader.readLong(input); hasValue = true; break;
                case 5: encryption = Reader.readString(input); hasValue = true; break;
                case 6: fileName = Reader.readString(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, cf);
        size += SizeUtils.sizeOf(2, regionId);
        size += SizeUtils.sizeOf(3, dirName);
        size += SizeUtils.sizeOf(4, fileSize);
        size += SizeUtils.sizeOf(5, encryption);
        size += SizeUtils.sizeOf(6, fileName);
        return size;
    }
}
