package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class BRaftStatus implements Message {
    private long knownAppliedIndex;

    private Map<String, RaftPeerStatus> unstableFollowers;

    private long applyingIndex;

    private long lastIndex;

    private String peerId;

    private long diskIndex;

    private RaftNodeState raftState;

    private long pendingQueueSize;

    private long committedIndex;

    private String leaderPeerId;

    private long firstIndex;

    private boolean readonly;

    private Map<String, RaftPeerStatus> stableFollowers;

    private long term;

    private long pendingIndex;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, raftState, out);
        Writer.write(11, peerId, out);
        Writer.write(12, leaderPeerId, out);
        Writer.write(13, readonly, out);
        Writer.write(14, term, out);
        Writer.write(15, committedIndex, out);
        Writer.write(16, knownAppliedIndex, out);
        Writer.write(17, pendingIndex, out);
        Writer.write(18, pendingQueueSize, out);
        Writer.write(19, applyingIndex, out);
        Writer.write(20, firstIndex, out);
        Writer.write(21, lastIndex, out);
        Writer.write(22, diskIndex, out);
        Writer.write(23, stableFollowers, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
        Writer.write(24, unstableFollowers, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: raftState = RaftNodeState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 11: peerId = Reader.readString(input); hasValue = true; break;
                case 12: leaderPeerId = Reader.readString(input); hasValue = true; break;
                case 13: readonly = Reader.readBoolean(input); hasValue = true; break;
                case 14: term = Reader.readLong(input); hasValue = true; break;
                case 15: committedIndex = Reader.readLong(input); hasValue = true; break;
                case 16: knownAppliedIndex = Reader.readLong(input); hasValue = true; break;
                case 17: pendingIndex = Reader.readLong(input); hasValue = true; break;
                case 18: pendingQueueSize = Reader.readLong(input); hasValue = true; break;
                case 19: applyingIndex = Reader.readLong(input); hasValue = true; break;
                case 20: firstIndex = Reader.readLong(input); hasValue = true; break;
                case 21: lastIndex = Reader.readLong(input); hasValue = true; break;
                case 22: diskIndex = Reader.readLong(input); hasValue = true; break;
                case 23: stableFollowers = Reader.readMap(number, stableFollowers, input, Reader::readString, in -> Reader.readMessage(new RaftPeerStatus(), in)); hasValue = true; break;
                case 24: unstableFollowers = Reader.readMap(number, unstableFollowers, input, Reader::readString, in -> Reader.readMessage(new RaftPeerStatus(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, raftState);
        size += SizeUtils.sizeOf(11, peerId);
        size += SizeUtils.sizeOf(12, leaderPeerId);
        size += SizeUtils.sizeOf(13, readonly);
        size += SizeUtils.sizeOf(14, term);
        size += SizeUtils.sizeOf(15, committedIndex);
        size += SizeUtils.sizeOf(16, knownAppliedIndex);
        size += SizeUtils.sizeOf(17, pendingIndex);
        size += SizeUtils.sizeOf(18, pendingQueueSize);
        size += SizeUtils.sizeOf(19, applyingIndex);
        size += SizeUtils.sizeOf(20, firstIndex);
        size += SizeUtils.sizeOf(21, lastIndex);
        size += SizeUtils.sizeOf(22, diskIndex);
        size += SizeUtils.sizeOf(23, stableFollowers, SizeUtils::sizeOf, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(24, unstableFollowers, SizeUtils::sizeOf, SizeUtils::sizeOf);
        return size;
    }
}
