package io.dingodb.sdk.service.desc.version;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.version.CompactionRequest;
import io.dingodb.sdk.service.entity.version.CompactionResponse;
import io.dingodb.sdk.service.entity.version.DeleteRangeRequest;
import io.dingodb.sdk.service.entity.version.DeleteRangeResponse;
import io.dingodb.sdk.service.entity.version.GetCurrVersionRequest;
import io.dingodb.sdk.service.entity.version.GetCurrVersionResponse;
import io.dingodb.sdk.service.entity.version.GetNewVersionRequest;
import io.dingodb.sdk.service.entity.version.GetNewVersionResponse;
import io.dingodb.sdk.service.entity.version.GetRawKvIndexRequest;
import io.dingodb.sdk.service.entity.version.GetRawKvIndexResponse;
import io.dingodb.sdk.service.entity.version.GetRawKvRevRequest;
import io.dingodb.sdk.service.entity.version.GetRawKvRevResponse;
import io.dingodb.sdk.service.entity.version.HelloRequest;
import io.dingodb.sdk.service.entity.version.HelloResponse;
import io.dingodb.sdk.service.entity.version.LeaseGrantRequest;
import io.dingodb.sdk.service.entity.version.LeaseGrantResponse;
import io.dingodb.sdk.service.entity.version.LeaseQueryRequest;
import io.dingodb.sdk.service.entity.version.LeaseQueryResponse;
import io.dingodb.sdk.service.entity.version.LeaseRenewRequest;
import io.dingodb.sdk.service.entity.version.LeaseRenewResponse;
import io.dingodb.sdk.service.entity.version.LeaseRevokeRequest;
import io.dingodb.sdk.service.entity.version.LeaseRevokeResponse;
import io.dingodb.sdk.service.entity.version.ListLeasesRequest;
import io.dingodb.sdk.service.entity.version.ListLeasesResponse;
import io.dingodb.sdk.service.entity.version.PutRequest;
import io.dingodb.sdk.service.entity.version.PutResponse;
import io.dingodb.sdk.service.entity.version.RangeRequest;
import io.dingodb.sdk.service.entity.version.RangeResponse;
import io.dingodb.sdk.service.entity.version.WatchRequest;
import io.dingodb.sdk.service.entity.version.WatchResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface VersionServiceDescriptors {
    MethodDescriptor<HelloRequest, HelloResponse> hello = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/Hello", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> helloHandlers = new ServiceCallCycles<>(hello, Hello.logger);

    MethodDescriptor<HelloRequest, HelloResponse> getMemoryInfo = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/GetMemoryInfo", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> getMemoryInfoHandlers = new ServiceCallCycles<>(getMemoryInfo, GetMemoryInfo.logger);

    MethodDescriptor<GetCurrVersionRequest, GetCurrVersionResponse> getCurrVersion = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/GetCurrVersion", GetCurrVersionRequest::new, GetCurrVersionResponse::new);

    ServiceCallCycles<GetCurrVersionRequest, GetCurrVersionResponse> getCurrVersionHandlers = new ServiceCallCycles<>(getCurrVersion, GetCurrVersion.logger);

    MethodDescriptor<GetNewVersionRequest, GetNewVersionResponse> getNewVersion = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/GetNewVersion", GetNewVersionRequest::new, GetNewVersionResponse::new);

    ServiceCallCycles<GetNewVersionRequest, GetNewVersionResponse> getNewVersionHandlers = new ServiceCallCycles<>(getNewVersion, GetNewVersion.logger);

    MethodDescriptor<RangeRequest, RangeResponse> kvRange = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/KvRange", RangeRequest::new, RangeResponse::new);

    ServiceCallCycles<RangeRequest, RangeResponse> kvRangeHandlers = new ServiceCallCycles<>(kvRange, KvRange.logger);

    MethodDescriptor<PutRequest, PutResponse> kvPut = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/KvPut", PutRequest::new, PutResponse::new);

    ServiceCallCycles<PutRequest, PutResponse> kvPutHandlers = new ServiceCallCycles<>(kvPut, KvPut.logger);

    MethodDescriptor<DeleteRangeRequest, DeleteRangeResponse> kvDeleteRange = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/KvDeleteRange", DeleteRangeRequest::new, DeleteRangeResponse::new);

    ServiceCallCycles<DeleteRangeRequest, DeleteRangeResponse> kvDeleteRangeHandlers = new ServiceCallCycles<>(kvDeleteRange, KvDeleteRange.logger);

    MethodDescriptor<CompactionRequest, CompactionResponse> kvCompaction = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/KvCompaction", CompactionRequest::new, CompactionResponse::new);

    ServiceCallCycles<CompactionRequest, CompactionResponse> kvCompactionHandlers = new ServiceCallCycles<>(kvCompaction, KvCompaction.logger);

    MethodDescriptor<LeaseGrantRequest, LeaseGrantResponse> leaseGrant = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/LeaseGrant", LeaseGrantRequest::new, LeaseGrantResponse::new);

    ServiceCallCycles<LeaseGrantRequest, LeaseGrantResponse> leaseGrantHandlers = new ServiceCallCycles<>(leaseGrant, LeaseGrant.logger);

    MethodDescriptor<LeaseRevokeRequest, LeaseRevokeResponse> leaseRevoke = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/LeaseRevoke", LeaseRevokeRequest::new, LeaseRevokeResponse::new);

    ServiceCallCycles<LeaseRevokeRequest, LeaseRevokeResponse> leaseRevokeHandlers = new ServiceCallCycles<>(leaseRevoke, LeaseRevoke.logger);

    MethodDescriptor<LeaseRenewRequest, LeaseRenewResponse> leaseRenew = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/LeaseRenew", LeaseRenewRequest::new, LeaseRenewResponse::new);

    ServiceCallCycles<LeaseRenewRequest, LeaseRenewResponse> leaseRenewHandlers = new ServiceCallCycles<>(leaseRenew, LeaseRenew.logger);

    MethodDescriptor<LeaseQueryRequest, LeaseQueryResponse> leaseQuery = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/LeaseQuery", LeaseQueryRequest::new, LeaseQueryResponse::new);

    ServiceCallCycles<LeaseQueryRequest, LeaseQueryResponse> leaseQueryHandlers = new ServiceCallCycles<>(leaseQuery, LeaseQuery.logger);

    MethodDescriptor<ListLeasesRequest, ListLeasesResponse> listLeases = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/ListLeases", ListLeasesRequest::new, ListLeasesResponse::new);

    ServiceCallCycles<ListLeasesRequest, ListLeasesResponse> listLeasesHandlers = new ServiceCallCycles<>(listLeases, ListLeases.logger);

    MethodDescriptor<WatchRequest, WatchResponse> watch = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/Watch", WatchRequest::new, WatchResponse::new);

    ServiceCallCycles<WatchRequest, WatchResponse> watchHandlers = new ServiceCallCycles<>(watch, Watch.logger);

    MethodDescriptor<GetRawKvIndexRequest, GetRawKvIndexResponse> getRawKvIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/GetRawKvIndex", GetRawKvIndexRequest::new, GetRawKvIndexResponse::new);

    ServiceCallCycles<GetRawKvIndexRequest, GetRawKvIndexResponse> getRawKvIndexHandlers = new ServiceCallCycles<>(getRawKvIndex, GetRawKvIndex.logger);

    MethodDescriptor<GetRawKvRevRequest, GetRawKvRevResponse> getRawKvRev = ServiceMethodBuilder.buildUnary("dingodb.pb.version.VersionService/GetRawKvRev", GetRawKvRevRequest::new, GetRawKvRevResponse::new);

    ServiceCallCycles<GetRawKvRevRequest, GetRawKvRevResponse> getRawKvRevHandlers = new ServiceCallCycles<>(getRawKvRev, GetRawKvRev.logger);

    final class Hello {
        public static final Logger logger = LoggerFactory.getLogger(Hello.class);
    }

    final class GetMemoryInfo {
        public static final Logger logger = LoggerFactory.getLogger(GetMemoryInfo.class);
    }

    final class GetCurrVersion {
        public static final Logger logger = LoggerFactory.getLogger(GetCurrVersion.class);
    }

    final class GetNewVersion {
        public static final Logger logger = LoggerFactory.getLogger(GetNewVersion.class);
    }

    final class KvRange {
        public static final Logger logger = LoggerFactory.getLogger(KvRange.class);
    }

    final class KvPut {
        public static final Logger logger = LoggerFactory.getLogger(KvPut.class);
    }

    final class KvDeleteRange {
        public static final Logger logger = LoggerFactory.getLogger(KvDeleteRange.class);
    }

    final class KvCompaction {
        public static final Logger logger = LoggerFactory.getLogger(KvCompaction.class);
    }

    final class LeaseGrant {
        public static final Logger logger = LoggerFactory.getLogger(LeaseGrant.class);
    }

    final class LeaseRevoke {
        public static final Logger logger = LoggerFactory.getLogger(LeaseRevoke.class);
    }

    final class LeaseRenew {
        public static final Logger logger = LoggerFactory.getLogger(LeaseRenew.class);
    }

    final class LeaseQuery {
        public static final Logger logger = LoggerFactory.getLogger(LeaseQuery.class);
    }

    final class ListLeases {
        public static final Logger logger = LoggerFactory.getLogger(ListLeases.class);
    }

    final class Watch {
        public static final Logger logger = LoggerFactory.getLogger(Watch.class);
    }

    final class GetRawKvIndex {
        public static final Logger logger = LoggerFactory.getLogger(GetRawKvIndex.class);
    }

    final class GetRawKvRev {
        public static final Logger logger = LoggerFactory.getLogger(GetRawKvRev.class);
    }
}
