package io.dingodb.sdk.service.desc.store;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.store.BackupDataRequest;
import io.dingodb.sdk.service.entity.store.BackupDataResponse;
import io.dingodb.sdk.service.entity.store.BackupMetaRequest;
import io.dingodb.sdk.service.entity.store.BackupMetaResponse;
import io.dingodb.sdk.service.entity.store.ControlConfigRequest;
import io.dingodb.sdk.service.entity.store.ControlConfigResponse;
import io.dingodb.sdk.service.entity.store.HelloRequest;
import io.dingodb.sdk.service.entity.store.HelloResponse;
import io.dingodb.sdk.service.entity.store.KvBatchCompareAndSetRequest;
import io.dingodb.sdk.service.entity.store.KvBatchCompareAndSetResponse;
import io.dingodb.sdk.service.entity.store.KvBatchDeleteRequest;
import io.dingodb.sdk.service.entity.store.KvBatchDeleteResponse;
import io.dingodb.sdk.service.entity.store.KvBatchGetRequest;
import io.dingodb.sdk.service.entity.store.KvBatchGetResponse;
import io.dingodb.sdk.service.entity.store.KvBatchPutIfAbsentRequest;
import io.dingodb.sdk.service.entity.store.KvBatchPutIfAbsentResponse;
import io.dingodb.sdk.service.entity.store.KvBatchPutRequest;
import io.dingodb.sdk.service.entity.store.KvBatchPutResponse;
import io.dingodb.sdk.service.entity.store.KvCompareAndSetRequest;
import io.dingodb.sdk.service.entity.store.KvCompareAndSetResponse;
import io.dingodb.sdk.service.entity.store.KvDeleteRangeRequest;
import io.dingodb.sdk.service.entity.store.KvDeleteRangeResponse;
import io.dingodb.sdk.service.entity.store.KvGetRequest;
import io.dingodb.sdk.service.entity.store.KvGetResponse;
import io.dingodb.sdk.service.entity.store.KvPutIfAbsentRequest;
import io.dingodb.sdk.service.entity.store.KvPutIfAbsentResponse;
import io.dingodb.sdk.service.entity.store.KvPutRequest;
import io.dingodb.sdk.service.entity.store.KvPutResponse;
import io.dingodb.sdk.service.entity.store.KvScanBeginRequest;
import io.dingodb.sdk.service.entity.store.KvScanBeginRequestV2;
import io.dingodb.sdk.service.entity.store.KvScanBeginResponse;
import io.dingodb.sdk.service.entity.store.KvScanBeginResponseV2;
import io.dingodb.sdk.service.entity.store.KvScanContinueRequest;
import io.dingodb.sdk.service.entity.store.KvScanContinueRequestV2;
import io.dingodb.sdk.service.entity.store.KvScanContinueResponse;
import io.dingodb.sdk.service.entity.store.KvScanContinueResponseV2;
import io.dingodb.sdk.service.entity.store.KvScanReleaseRequest;
import io.dingodb.sdk.service.entity.store.KvScanReleaseRequestV2;
import io.dingodb.sdk.service.entity.store.KvScanReleaseResponse;
import io.dingodb.sdk.service.entity.store.KvScanReleaseResponseV2;
import io.dingodb.sdk.service.entity.store.RestoreDataRequest;
import io.dingodb.sdk.service.entity.store.RestoreDataResponse;
import io.dingodb.sdk.service.entity.store.RestoreMetaRequest;
import io.dingodb.sdk.service.entity.store.RestoreMetaResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchGetRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchGetResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnCheckSecondaryLocksRequest;
import io.dingodb.sdk.service.entity.store.TxnCheckSecondaryLocksResponse;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusRequest;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusResponse;
import io.dingodb.sdk.service.entity.store.TxnCommitRequest;
import io.dingodb.sdk.service.entity.store.TxnCommitResponse;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeRequest;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeResponse;
import io.dingodb.sdk.service.entity.store.TxnDumpRequest;
import io.dingodb.sdk.service.entity.store.TxnDumpResponse;
import io.dingodb.sdk.service.entity.store.TxnGcRequest;
import io.dingodb.sdk.service.entity.store.TxnGcResponse;
import io.dingodb.sdk.service.entity.store.TxnGetRequest;
import io.dingodb.sdk.service.entity.store.TxnGetResponse;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatRequest;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnPrewriteRequest;
import io.dingodb.sdk.service.entity.store.TxnPrewriteResponse;
import io.dingodb.sdk.service.entity.store.TxnResolveLockRequest;
import io.dingodb.sdk.service.entity.store.TxnResolveLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanLockRequest;
import io.dingodb.sdk.service.entity.store.TxnScanLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanRequest;
import io.dingodb.sdk.service.entity.store.TxnScanResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface StoreServiceDescriptors {
    MethodDescriptor<HelloRequest, HelloResponse> hello = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/Hello", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> helloHandlers = new ServiceCallCycles<>(hello, Hello.logger);

    MethodDescriptor<HelloRequest, HelloResponse> getMemoryInfo = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/GetMemoryInfo", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> getMemoryInfoHandlers = new ServiceCallCycles<>(getMemoryInfo, GetMemoryInfo.logger);

    MethodDescriptor<KvGetRequest, KvGetResponse> kvGet = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvGet", KvGetRequest::new, KvGetResponse::new);

    ServiceCallCycles<KvGetRequest, KvGetResponse> kvGetHandlers = new ServiceCallCycles<>(kvGet, KvGet.logger);

    MethodDescriptor<KvBatchGetRequest, KvBatchGetResponse> kvBatchGet = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvBatchGet", KvBatchGetRequest::new, KvBatchGetResponse::new);

    ServiceCallCycles<KvBatchGetRequest, KvBatchGetResponse> kvBatchGetHandlers = new ServiceCallCycles<>(kvBatchGet, KvBatchGet.logger);

    MethodDescriptor<KvPutRequest, KvPutResponse> kvPut = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvPut", KvPutRequest::new, KvPutResponse::new);

    ServiceCallCycles<KvPutRequest, KvPutResponse> kvPutHandlers = new ServiceCallCycles<>(kvPut, KvPut.logger);

    MethodDescriptor<KvBatchPutRequest, KvBatchPutResponse> kvBatchPut = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvBatchPut", KvBatchPutRequest::new, KvBatchPutResponse::new);

    ServiceCallCycles<KvBatchPutRequest, KvBatchPutResponse> kvBatchPutHandlers = new ServiceCallCycles<>(kvBatchPut, KvBatchPut.logger);

    MethodDescriptor<KvPutIfAbsentRequest, KvPutIfAbsentResponse> kvPutIfAbsent = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvPutIfAbsent", KvPutIfAbsentRequest::new, KvPutIfAbsentResponse::new);

    ServiceCallCycles<KvPutIfAbsentRequest, KvPutIfAbsentResponse> kvPutIfAbsentHandlers = new ServiceCallCycles<>(kvPutIfAbsent, KvPutIfAbsent.logger);

    MethodDescriptor<KvBatchPutIfAbsentRequest, KvBatchPutIfAbsentResponse> kvBatchPutIfAbsent = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvBatchPutIfAbsent", KvBatchPutIfAbsentRequest::new, KvBatchPutIfAbsentResponse::new);

    ServiceCallCycles<KvBatchPutIfAbsentRequest, KvBatchPutIfAbsentResponse> kvBatchPutIfAbsentHandlers = new ServiceCallCycles<>(kvBatchPutIfAbsent, KvBatchPutIfAbsent.logger);

    MethodDescriptor<KvBatchDeleteRequest, KvBatchDeleteResponse> kvBatchDelete = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvBatchDelete", KvBatchDeleteRequest::new, KvBatchDeleteResponse::new);

    ServiceCallCycles<KvBatchDeleteRequest, KvBatchDeleteResponse> kvBatchDeleteHandlers = new ServiceCallCycles<>(kvBatchDelete, KvBatchDelete.logger);

    MethodDescriptor<KvDeleteRangeRequest, KvDeleteRangeResponse> kvDeleteRange = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvDeleteRange", KvDeleteRangeRequest::new, KvDeleteRangeResponse::new);

    ServiceCallCycles<KvDeleteRangeRequest, KvDeleteRangeResponse> kvDeleteRangeHandlers = new ServiceCallCycles<>(kvDeleteRange, KvDeleteRange.logger);

    MethodDescriptor<KvCompareAndSetRequest, KvCompareAndSetResponse> kvCompareAndSet = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvCompareAndSet", KvCompareAndSetRequest::new, KvCompareAndSetResponse::new);

    ServiceCallCycles<KvCompareAndSetRequest, KvCompareAndSetResponse> kvCompareAndSetHandlers = new ServiceCallCycles<>(kvCompareAndSet, KvCompareAndSet.logger);

    MethodDescriptor<KvBatchCompareAndSetRequest, KvBatchCompareAndSetResponse> kvBatchCompareAndSet = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvBatchCompareAndSet", KvBatchCompareAndSetRequest::new, KvBatchCompareAndSetResponse::new);

    ServiceCallCycles<KvBatchCompareAndSetRequest, KvBatchCompareAndSetResponse> kvBatchCompareAndSetHandlers = new ServiceCallCycles<>(kvBatchCompareAndSet, KvBatchCompareAndSet.logger);

    MethodDescriptor<KvScanBeginRequest, KvScanBeginResponse> kvScanBegin = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvScanBegin", KvScanBeginRequest::new, KvScanBeginResponse::new);

    ServiceCallCycles<KvScanBeginRequest, KvScanBeginResponse> kvScanBeginHandlers = new ServiceCallCycles<>(kvScanBegin, KvScanBegin.logger);

    MethodDescriptor<KvScanContinueRequest, KvScanContinueResponse> kvScanContinue = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvScanContinue", KvScanContinueRequest::new, KvScanContinueResponse::new);

    ServiceCallCycles<KvScanContinueRequest, KvScanContinueResponse> kvScanContinueHandlers = new ServiceCallCycles<>(kvScanContinue, KvScanContinue.logger);

    MethodDescriptor<KvScanReleaseRequest, KvScanReleaseResponse> kvScanRelease = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvScanRelease", KvScanReleaseRequest::new, KvScanReleaseResponse::new);

    ServiceCallCycles<KvScanReleaseRequest, KvScanReleaseResponse> kvScanReleaseHandlers = new ServiceCallCycles<>(kvScanRelease, KvScanRelease.logger);

    MethodDescriptor<KvScanBeginRequestV2, KvScanBeginResponseV2> kvScanBeginV2 = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvScanBeginV2", KvScanBeginRequestV2::new, KvScanBeginResponseV2::new);

    ServiceCallCycles<KvScanBeginRequestV2, KvScanBeginResponseV2> kvScanBeginV2Handlers = new ServiceCallCycles<>(kvScanBeginV2, KvScanBeginV2.logger);

    MethodDescriptor<KvScanContinueRequestV2, KvScanContinueResponseV2> kvScanContinueV2 = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvScanContinueV2", KvScanContinueRequestV2::new, KvScanContinueResponseV2::new);

    ServiceCallCycles<KvScanContinueRequestV2, KvScanContinueResponseV2> kvScanContinueV2Handlers = new ServiceCallCycles<>(kvScanContinueV2, KvScanContinueV2.logger);

    MethodDescriptor<KvScanReleaseRequestV2, KvScanReleaseResponseV2> kvScanReleaseV2 = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/KvScanReleaseV2", KvScanReleaseRequestV2::new, KvScanReleaseResponseV2::new);

    ServiceCallCycles<KvScanReleaseRequestV2, KvScanReleaseResponseV2> kvScanReleaseV2Handlers = new ServiceCallCycles<>(kvScanReleaseV2, KvScanReleaseV2.logger);

    MethodDescriptor<TxnGetRequest, TxnGetResponse> txnGet = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnGet", TxnGetRequest::new, TxnGetResponse::new);

    ServiceCallCycles<TxnGetRequest, TxnGetResponse> txnGetHandlers = new ServiceCallCycles<>(txnGet, TxnGet.logger);

    MethodDescriptor<TxnBatchGetRequest, TxnBatchGetResponse> txnBatchGet = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnBatchGet", TxnBatchGetRequest::new, TxnBatchGetResponse::new);

    ServiceCallCycles<TxnBatchGetRequest, TxnBatchGetResponse> txnBatchGetHandlers = new ServiceCallCycles<>(txnBatchGet, TxnBatchGet.logger);

    MethodDescriptor<TxnScanRequest, TxnScanResponse> txnScan = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnScan", TxnScanRequest::new, TxnScanResponse::new);

    ServiceCallCycles<TxnScanRequest, TxnScanResponse> txnScanHandlers = new ServiceCallCycles<>(txnScan, TxnScan.logger);

    MethodDescriptor<TxnDumpRequest, TxnDumpResponse> txnDump = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnDump", TxnDumpRequest::new, TxnDumpResponse::new);

    ServiceCallCycles<TxnDumpRequest, TxnDumpResponse> txnDumpHandlers = new ServiceCallCycles<>(txnDump, TxnDump.logger);

    MethodDescriptor<TxnPessimisticLockRequest, TxnPessimisticLockResponse> txnPessimisticLock = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnPessimisticLock", TxnPessimisticLockRequest::new, TxnPessimisticLockResponse::new);

    ServiceCallCycles<TxnPessimisticLockRequest, TxnPessimisticLockResponse> txnPessimisticLockHandlers = new ServiceCallCycles<>(txnPessimisticLock, TxnPessimisticLock.logger);

    MethodDescriptor<TxnPessimisticRollbackRequest, TxnPessimisticRollbackResponse> txnPessimisticRollback = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnPessimisticRollback", TxnPessimisticRollbackRequest::new, TxnPessimisticRollbackResponse::new);

    ServiceCallCycles<TxnPessimisticRollbackRequest, TxnPessimisticRollbackResponse> txnPessimisticRollbackHandlers = new ServiceCallCycles<>(txnPessimisticRollback, TxnPessimisticRollback.logger);

    MethodDescriptor<TxnPrewriteRequest, TxnPrewriteResponse> txnPrewrite = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnPrewrite", TxnPrewriteRequest::new, TxnPrewriteResponse::new);

    ServiceCallCycles<TxnPrewriteRequest, TxnPrewriteResponse> txnPrewriteHandlers = new ServiceCallCycles<>(txnPrewrite, TxnPrewrite.logger);

    MethodDescriptor<TxnCommitRequest, TxnCommitResponse> txnCommit = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnCommit", TxnCommitRequest::new, TxnCommitResponse::new);

    ServiceCallCycles<TxnCommitRequest, TxnCommitResponse> txnCommitHandlers = new ServiceCallCycles<>(txnCommit, TxnCommit.logger);

    MethodDescriptor<TxnCheckTxnStatusRequest, TxnCheckTxnStatusResponse> txnCheckTxnStatus = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnCheckTxnStatus", TxnCheckTxnStatusRequest::new, TxnCheckTxnStatusResponse::new);

    ServiceCallCycles<TxnCheckTxnStatusRequest, TxnCheckTxnStatusResponse> txnCheckTxnStatusHandlers = new ServiceCallCycles<>(txnCheckTxnStatus, TxnCheckTxnStatus.logger);

    MethodDescriptor<TxnResolveLockRequest, TxnResolveLockResponse> txnResolveLock = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnResolveLock", TxnResolveLockRequest::new, TxnResolveLockResponse::new);

    ServiceCallCycles<TxnResolveLockRequest, TxnResolveLockResponse> txnResolveLockHandlers = new ServiceCallCycles<>(txnResolveLock, TxnResolveLock.logger);

    MethodDescriptor<TxnBatchRollbackRequest, TxnBatchRollbackResponse> txnBatchRollback = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnBatchRollback", TxnBatchRollbackRequest::new, TxnBatchRollbackResponse::new);

    ServiceCallCycles<TxnBatchRollbackRequest, TxnBatchRollbackResponse> txnBatchRollbackHandlers = new ServiceCallCycles<>(txnBatchRollback, TxnBatchRollback.logger);

    MethodDescriptor<TxnScanLockRequest, TxnScanLockResponse> txnScanLock = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnScanLock", TxnScanLockRequest::new, TxnScanLockResponse::new);

    ServiceCallCycles<TxnScanLockRequest, TxnScanLockResponse> txnScanLockHandlers = new ServiceCallCycles<>(txnScanLock, TxnScanLock.logger);

    MethodDescriptor<TxnHeartBeatRequest, TxnHeartBeatResponse> txnHeartBeat = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnHeartBeat", TxnHeartBeatRequest::new, TxnHeartBeatResponse::new);

    ServiceCallCycles<TxnHeartBeatRequest, TxnHeartBeatResponse> txnHeartBeatHandlers = new ServiceCallCycles<>(txnHeartBeat, TxnHeartBeat.logger);

    MethodDescriptor<TxnGcRequest, TxnGcResponse> txnGc = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnGc", TxnGcRequest::new, TxnGcResponse::new);

    ServiceCallCycles<TxnGcRequest, TxnGcResponse> txnGcHandlers = new ServiceCallCycles<>(txnGc, TxnGc.logger);

    MethodDescriptor<TxnDeleteRangeRequest, TxnDeleteRangeResponse> txnDeleteRange = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnDeleteRange", TxnDeleteRangeRequest::new, TxnDeleteRangeResponse::new);

    ServiceCallCycles<TxnDeleteRangeRequest, TxnDeleteRangeResponse> txnDeleteRangeHandlers = new ServiceCallCycles<>(txnDeleteRange, TxnDeleteRange.logger);

    MethodDescriptor<TxnCheckSecondaryLocksRequest, TxnCheckSecondaryLocksResponse> txnCheckSecondaryLocks = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/TxnCheckSecondaryLocks", TxnCheckSecondaryLocksRequest::new, TxnCheckSecondaryLocksResponse::new);

    ServiceCallCycles<TxnCheckSecondaryLocksRequest, TxnCheckSecondaryLocksResponse> txnCheckSecondaryLocksHandlers = new ServiceCallCycles<>(txnCheckSecondaryLocks, TxnCheckSecondaryLocks.logger);

    MethodDescriptor<BackupDataRequest, BackupDataResponse> backupData = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/BackupData", BackupDataRequest::new, BackupDataResponse::new);

    ServiceCallCycles<BackupDataRequest, BackupDataResponse> backupDataHandlers = new ServiceCallCycles<>(backupData, BackupData.logger);

    MethodDescriptor<BackupMetaRequest, BackupMetaResponse> backupMeta = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/BackupMeta", BackupMetaRequest::new, BackupMetaResponse::new);

    ServiceCallCycles<BackupMetaRequest, BackupMetaResponse> backupMetaHandlers = new ServiceCallCycles<>(backupMeta, BackupMeta.logger);

    MethodDescriptor<ControlConfigRequest, ControlConfigResponse> controlConfig = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/ControlConfig", ControlConfigRequest::new, ControlConfigResponse::new);

    ServiceCallCycles<ControlConfigRequest, ControlConfigResponse> controlConfigHandlers = new ServiceCallCycles<>(controlConfig, ControlConfig.logger);

    MethodDescriptor<RestoreDataRequest, RestoreDataResponse> restoreData = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/RestoreData", RestoreDataRequest::new, RestoreDataResponse::new);

    ServiceCallCycles<RestoreDataRequest, RestoreDataResponse> restoreDataHandlers = new ServiceCallCycles<>(restoreData, RestoreData.logger);

    MethodDescriptor<RestoreMetaRequest, RestoreMetaResponse> restoreMeta = ServiceMethodBuilder.buildUnary("dingodb.pb.store.StoreService/RestoreMeta", RestoreMetaRequest::new, RestoreMetaResponse::new);

    ServiceCallCycles<RestoreMetaRequest, RestoreMetaResponse> restoreMetaHandlers = new ServiceCallCycles<>(restoreMeta, RestoreMeta.logger);

    final class Hello {
        public static final Logger logger = LoggerFactory.getLogger(Hello.class);
    }

    final class GetMemoryInfo {
        public static final Logger logger = LoggerFactory.getLogger(GetMemoryInfo.class);
    }

    final class KvGet {
        public static final Logger logger = LoggerFactory.getLogger(KvGet.class);
    }

    final class KvBatchGet {
        public static final Logger logger = LoggerFactory.getLogger(KvBatchGet.class);
    }

    final class KvPut {
        public static final Logger logger = LoggerFactory.getLogger(KvPut.class);
    }

    final class KvBatchPut {
        public static final Logger logger = LoggerFactory.getLogger(KvBatchPut.class);
    }

    final class KvPutIfAbsent {
        public static final Logger logger = LoggerFactory.getLogger(KvPutIfAbsent.class);
    }

    final class KvBatchPutIfAbsent {
        public static final Logger logger = LoggerFactory.getLogger(KvBatchPutIfAbsent.class);
    }

    final class KvBatchDelete {
        public static final Logger logger = LoggerFactory.getLogger(KvBatchDelete.class);
    }

    final class KvDeleteRange {
        public static final Logger logger = LoggerFactory.getLogger(KvDeleteRange.class);
    }

    final class KvCompareAndSet {
        public static final Logger logger = LoggerFactory.getLogger(KvCompareAndSet.class);
    }

    final class KvBatchCompareAndSet {
        public static final Logger logger = LoggerFactory.getLogger(KvBatchCompareAndSet.class);
    }

    final class KvScanBegin {
        public static final Logger logger = LoggerFactory.getLogger(KvScanBegin.class);
    }

    final class KvScanContinue {
        public static final Logger logger = LoggerFactory.getLogger(KvScanContinue.class);
    }

    final class KvScanRelease {
        public static final Logger logger = LoggerFactory.getLogger(KvScanRelease.class);
    }

    final class KvScanBeginV2 {
        public static final Logger logger = LoggerFactory.getLogger(KvScanBeginV2.class);
    }

    final class KvScanContinueV2 {
        public static final Logger logger = LoggerFactory.getLogger(KvScanContinueV2.class);
    }

    final class KvScanReleaseV2 {
        public static final Logger logger = LoggerFactory.getLogger(KvScanReleaseV2.class);
    }

    final class TxnGet {
        public static final Logger logger = LoggerFactory.getLogger(TxnGet.class);
    }

    final class TxnBatchGet {
        public static final Logger logger = LoggerFactory.getLogger(TxnBatchGet.class);
    }

    final class TxnScan {
        public static final Logger logger = LoggerFactory.getLogger(TxnScan.class);
    }

    final class TxnDump {
        public static final Logger logger = LoggerFactory.getLogger(TxnDump.class);
    }

    final class TxnPessimisticLock {
        public static final Logger logger = LoggerFactory.getLogger(TxnPessimisticLock.class);
    }

    final class TxnPessimisticRollback {
        public static final Logger logger = LoggerFactory.getLogger(TxnPessimisticRollback.class);
    }

    final class TxnPrewrite {
        public static final Logger logger = LoggerFactory.getLogger(TxnPrewrite.class);
    }

    final class TxnCommit {
        public static final Logger logger = LoggerFactory.getLogger(TxnCommit.class);
    }

    final class TxnCheckTxnStatus {
        public static final Logger logger = LoggerFactory.getLogger(TxnCheckTxnStatus.class);
    }

    final class TxnResolveLock {
        public static final Logger logger = LoggerFactory.getLogger(TxnResolveLock.class);
    }

    final class TxnBatchRollback {
        public static final Logger logger = LoggerFactory.getLogger(TxnBatchRollback.class);
    }

    final class TxnScanLock {
        public static final Logger logger = LoggerFactory.getLogger(TxnScanLock.class);
    }

    final class TxnHeartBeat {
        public static final Logger logger = LoggerFactory.getLogger(TxnHeartBeat.class);
    }

    final class TxnGc {
        public static final Logger logger = LoggerFactory.getLogger(TxnGc.class);
    }

    final class TxnDeleteRange {
        public static final Logger logger = LoggerFactory.getLogger(TxnDeleteRange.class);
    }

    final class TxnCheckSecondaryLocks {
        public static final Logger logger = LoggerFactory.getLogger(TxnCheckSecondaryLocks.class);
    }

    final class BackupData {
        public static final Logger logger = LoggerFactory.getLogger(BackupData.class);
    }

    final class BackupMeta {
        public static final Logger logger = LoggerFactory.getLogger(BackupMeta.class);
    }

    final class ControlConfig {
        public static final Logger logger = LoggerFactory.getLogger(ControlConfig.class);
    }

    final class RestoreData {
        public static final Logger logger = LoggerFactory.getLogger(RestoreData.class);
    }

    final class RestoreMeta {
        public static final Logger logger = LoggerFactory.getLogger(RestoreMeta.class);
    }
}
