package io.dingodb.sdk.service.desc.node;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.node.ChangeLogLevelRequest;
import io.dingodb.sdk.service.entity.node.ChangeLogLevelResponse;
import io.dingodb.sdk.service.entity.node.CheckVectorIndexRequest;
import io.dingodb.sdk.service.entity.node.CheckVectorIndexResponse;
import io.dingodb.sdk.service.entity.node.CommitMergeRequest;
import io.dingodb.sdk.service.entity.node.CommitMergeResponse;
import io.dingodb.sdk.service.entity.node.DeleteFailPointRequest;
import io.dingodb.sdk.service.entity.node.DeleteFailPointResponse;
import io.dingodb.sdk.service.entity.node.GetFailPointRequest;
import io.dingodb.sdk.service.entity.node.GetFailPointResponse;
import io.dingodb.sdk.service.entity.node.GetLogLevelRequest;
import io.dingodb.sdk.service.entity.node.GetLogLevelResponse;
import io.dingodb.sdk.service.entity.node.GetMemoryStatsRequest;
import io.dingodb.sdk.service.entity.node.GetMemoryStatsResponse;
import io.dingodb.sdk.service.entity.node.GetNodeInfoRequest;
import io.dingodb.sdk.service.entity.node.GetNodeInfoResponse;
import io.dingodb.sdk.service.entity.node.GetRaftStatusRequest;
import io.dingodb.sdk.service.entity.node.GetRaftStatusResponse;
import io.dingodb.sdk.service.entity.node.GetRegionInfoRequest;
import io.dingodb.sdk.service.entity.node.GetRegionInfoResponse;
import io.dingodb.sdk.service.entity.node.GetVectorIndexSnapshotRequest;
import io.dingodb.sdk.service.entity.node.GetVectorIndexSnapshotResponse;
import io.dingodb.sdk.service.entity.node.InstallVectorIndexSnapshotRequest;
import io.dingodb.sdk.service.entity.node.InstallVectorIndexSnapshotResponse;
import io.dingodb.sdk.service.entity.node.MetricsRequest;
import io.dingodb.sdk.service.entity.node.MetricsResponse;
import io.dingodb.sdk.service.entity.node.ReleaseFreeMemoryRequest;
import io.dingodb.sdk.service.entity.node.ReleaseFreeMemoryResponse;
import io.dingodb.sdk.service.entity.node.SetFailPointRequest;
import io.dingodb.sdk.service.entity.node.SetFailPointResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NodeServiceDescriptors {
    MethodDescriptor<GetNodeInfoRequest, GetNodeInfoResponse> getNodeInfo = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/GetNodeInfo", GetNodeInfoRequest::new, GetNodeInfoResponse::new);

    ServiceCallCycles<GetNodeInfoRequest, GetNodeInfoResponse> getNodeInfoHandlers = new ServiceCallCycles<>(getNodeInfo, GetNodeInfo.logger);

    MethodDescriptor<GetRegionInfoRequest, GetRegionInfoResponse> getRegionInfo = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/GetRegionInfo", GetRegionInfoRequest::new, GetRegionInfoResponse::new);

    ServiceCallCycles<GetRegionInfoRequest, GetRegionInfoResponse> getRegionInfoHandlers = new ServiceCallCycles<>(getRegionInfo, GetRegionInfo.logger);

    MethodDescriptor<GetRaftStatusRequest, GetRaftStatusResponse> getRaftStatus = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/GetRaftStatus", GetRaftStatusRequest::new, GetRaftStatusResponse::new);

    ServiceCallCycles<GetRaftStatusRequest, GetRaftStatusResponse> getRaftStatusHandlers = new ServiceCallCycles<>(getRaftStatus, GetRaftStatus.logger);

    MethodDescriptor<GetLogLevelRequest, GetLogLevelResponse> getLogLevel = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/GetLogLevel", GetLogLevelRequest::new, GetLogLevelResponse::new);

    ServiceCallCycles<GetLogLevelRequest, GetLogLevelResponse> getLogLevelHandlers = new ServiceCallCycles<>(getLogLevel, GetLogLevel.logger);

    MethodDescriptor<ChangeLogLevelRequest, ChangeLogLevelResponse> changeLogLevel = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/ChangeLogLevel", ChangeLogLevelRequest::new, ChangeLogLevelResponse::new);

    ServiceCallCycles<ChangeLogLevelRequest, ChangeLogLevelResponse> changeLogLevelHandlers = new ServiceCallCycles<>(changeLogLevel, ChangeLogLevel.logger);

    MethodDescriptor<MetricsRequest, MetricsResponse> dingoMetrics = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/DingoMetrics", MetricsRequest::new, MetricsResponse::new);

    ServiceCallCycles<MetricsRequest, MetricsResponse> dingoMetricsHandlers = new ServiceCallCycles<>(dingoMetrics, DingoMetrics.logger);

    MethodDescriptor<SetFailPointRequest, SetFailPointResponse> setFailPoint = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/SetFailPoint", SetFailPointRequest::new, SetFailPointResponse::new);

    ServiceCallCycles<SetFailPointRequest, SetFailPointResponse> setFailPointHandlers = new ServiceCallCycles<>(setFailPoint, SetFailPoint.logger);

    MethodDescriptor<GetFailPointRequest, GetFailPointResponse> getFailPoints = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/GetFailPoints", GetFailPointRequest::new, GetFailPointResponse::new);

    ServiceCallCycles<GetFailPointRequest, GetFailPointResponse> getFailPointsHandlers = new ServiceCallCycles<>(getFailPoints, GetFailPoints.logger);

    MethodDescriptor<DeleteFailPointRequest, DeleteFailPointResponse> deleteFailPoints = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/DeleteFailPoints", DeleteFailPointRequest::new, DeleteFailPointResponse::new);

    ServiceCallCycles<DeleteFailPointRequest, DeleteFailPointResponse> deleteFailPointsHandlers = new ServiceCallCycles<>(deleteFailPoints, DeleteFailPoints.logger);

    MethodDescriptor<InstallVectorIndexSnapshotRequest, InstallVectorIndexSnapshotResponse> installVectorIndexSnapshot = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/InstallVectorIndexSnapshot", InstallVectorIndexSnapshotRequest::new, InstallVectorIndexSnapshotResponse::new);

    ServiceCallCycles<InstallVectorIndexSnapshotRequest, InstallVectorIndexSnapshotResponse> installVectorIndexSnapshotHandlers = new ServiceCallCycles<>(installVectorIndexSnapshot, InstallVectorIndexSnapshot.logger);

    MethodDescriptor<GetVectorIndexSnapshotRequest, GetVectorIndexSnapshotResponse> getVectorIndexSnapshot = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/GetVectorIndexSnapshot", GetVectorIndexSnapshotRequest::new, GetVectorIndexSnapshotResponse::new);

    ServiceCallCycles<GetVectorIndexSnapshotRequest, GetVectorIndexSnapshotResponse> getVectorIndexSnapshotHandlers = new ServiceCallCycles<>(getVectorIndexSnapshot, GetVectorIndexSnapshot.logger);

    MethodDescriptor<CheckVectorIndexRequest, CheckVectorIndexResponse> checkVectorIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/CheckVectorIndex", CheckVectorIndexRequest::new, CheckVectorIndexResponse::new);

    ServiceCallCycles<CheckVectorIndexRequest, CheckVectorIndexResponse> checkVectorIndexHandlers = new ServiceCallCycles<>(checkVectorIndex, CheckVectorIndex.logger);

    MethodDescriptor<CommitMergeRequest, CommitMergeResponse> commitMerge = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/CommitMerge", CommitMergeRequest::new, CommitMergeResponse::new);

    ServiceCallCycles<CommitMergeRequest, CommitMergeResponse> commitMergeHandlers = new ServiceCallCycles<>(commitMerge, CommitMerge.logger);

    MethodDescriptor<GetMemoryStatsRequest, GetMemoryStatsResponse> getMemoryStats = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/GetMemoryStats", GetMemoryStatsRequest::new, GetMemoryStatsResponse::new);

    ServiceCallCycles<GetMemoryStatsRequest, GetMemoryStatsResponse> getMemoryStatsHandlers = new ServiceCallCycles<>(getMemoryStats, GetMemoryStats.logger);

    MethodDescriptor<ReleaseFreeMemoryRequest, ReleaseFreeMemoryResponse> releaseFreeMemory = ServiceMethodBuilder.buildUnary("dingodb.pb.node.NodeService/ReleaseFreeMemory", ReleaseFreeMemoryRequest::new, ReleaseFreeMemoryResponse::new);

    ServiceCallCycles<ReleaseFreeMemoryRequest, ReleaseFreeMemoryResponse> releaseFreeMemoryHandlers = new ServiceCallCycles<>(releaseFreeMemory, ReleaseFreeMemory.logger);

    final class GetNodeInfo {
        public static final Logger logger = LoggerFactory.getLogger(GetNodeInfo.class);
    }

    final class GetRegionInfo {
        public static final Logger logger = LoggerFactory.getLogger(GetRegionInfo.class);
    }

    final class GetRaftStatus {
        public static final Logger logger = LoggerFactory.getLogger(GetRaftStatus.class);
    }

    final class GetLogLevel {
        public static final Logger logger = LoggerFactory.getLogger(GetLogLevel.class);
    }

    final class ChangeLogLevel {
        public static final Logger logger = LoggerFactory.getLogger(ChangeLogLevel.class);
    }

    final class DingoMetrics {
        public static final Logger logger = LoggerFactory.getLogger(DingoMetrics.class);
    }

    final class SetFailPoint {
        public static final Logger logger = LoggerFactory.getLogger(SetFailPoint.class);
    }

    final class GetFailPoints {
        public static final Logger logger = LoggerFactory.getLogger(GetFailPoints.class);
    }

    final class DeleteFailPoints {
        public static final Logger logger = LoggerFactory.getLogger(DeleteFailPoints.class);
    }

    final class InstallVectorIndexSnapshot {
        public static final Logger logger = LoggerFactory.getLogger(InstallVectorIndexSnapshot.class);
    }

    final class GetVectorIndexSnapshot {
        public static final Logger logger = LoggerFactory.getLogger(GetVectorIndexSnapshot.class);
    }

    final class CheckVectorIndex {
        public static final Logger logger = LoggerFactory.getLogger(CheckVectorIndex.class);
    }

    final class CommitMerge {
        public static final Logger logger = LoggerFactory.getLogger(CommitMerge.class);
    }

    final class GetMemoryStats {
        public static final Logger logger = LoggerFactory.getLogger(GetMemoryStats.class);
    }

    final class ReleaseFreeMemory {
        public static final Logger logger = LoggerFactory.getLogger(ReleaseFreeMemory.class);
    }
}
