package io.dingodb.sdk.service.desc.meta;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.meta.AddIndexOnTableRequest;
import io.dingodb.sdk.service.entity.meta.AddIndexOnTableResponse;
import io.dingodb.sdk.service.entity.meta.CleanDeletedIndexRequest;
import io.dingodb.sdk.service.entity.meta.CleanDeletedIndexResponse;
import io.dingodb.sdk.service.entity.meta.CleanDeletedTableRequest;
import io.dingodb.sdk.service.entity.meta.CleanDeletedTableResponse;
import io.dingodb.sdk.service.entity.meta.CreateAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.CreateAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.CreateAutoIncrementsRequest;
import io.dingodb.sdk.service.entity.meta.CreateAutoIncrementsResponse;
import io.dingodb.sdk.service.entity.meta.CreateIndexIdRequest;
import io.dingodb.sdk.service.entity.meta.CreateIndexIdResponse;
import io.dingodb.sdk.service.entity.meta.CreateIndexMetasRequest;
import io.dingodb.sdk.service.entity.meta.CreateIndexMetasResponse;
import io.dingodb.sdk.service.entity.meta.CreateIndexRequest;
import io.dingodb.sdk.service.entity.meta.CreateIndexResponse;
import io.dingodb.sdk.service.entity.meta.CreateOrUpdateAutoIncrementsRequest;
import io.dingodb.sdk.service.entity.meta.CreateOrUpdateAutoIncrementsResponse;
import io.dingodb.sdk.service.entity.meta.CreateSchemaRequest;
import io.dingodb.sdk.service.entity.meta.CreateSchemaResponse;
import io.dingodb.sdk.service.entity.meta.CreateSchemasRequest;
import io.dingodb.sdk.service.entity.meta.CreateSchemasResponse;
import io.dingodb.sdk.service.entity.meta.CreateTableIdRequest;
import io.dingodb.sdk.service.entity.meta.CreateTableIdResponse;
import io.dingodb.sdk.service.entity.meta.CreateTableIdsRequest;
import io.dingodb.sdk.service.entity.meta.CreateTableIdsResponse;
import io.dingodb.sdk.service.entity.meta.CreateTableRequest;
import io.dingodb.sdk.service.entity.meta.CreateTableResponse;
import io.dingodb.sdk.service.entity.meta.CreateTablesRequest;
import io.dingodb.sdk.service.entity.meta.CreateTablesResponse;
import io.dingodb.sdk.service.entity.meta.CreateTenantRequest;
import io.dingodb.sdk.service.entity.meta.CreateTenantResponse;
import io.dingodb.sdk.service.entity.meta.CreateTenantsRequest;
import io.dingodb.sdk.service.entity.meta.CreateTenantsResponse;
import io.dingodb.sdk.service.entity.meta.DeleteAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.DeleteAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.DropIndexOnTableRequest;
import io.dingodb.sdk.service.entity.meta.DropIndexOnTableResponse;
import io.dingodb.sdk.service.entity.meta.DropIndexRequest;
import io.dingodb.sdk.service.entity.meta.DropIndexResponse;
import io.dingodb.sdk.service.entity.meta.DropSchemaRequest;
import io.dingodb.sdk.service.entity.meta.DropSchemaResponse;
import io.dingodb.sdk.service.entity.meta.DropTableRequest;
import io.dingodb.sdk.service.entity.meta.DropTableResponse;
import io.dingodb.sdk.service.entity.meta.DropTablesRequest;
import io.dingodb.sdk.service.entity.meta.DropTablesResponse;
import io.dingodb.sdk.service.entity.meta.DropTenantRequest;
import io.dingodb.sdk.service.entity.meta.DropTenantResponse;
import io.dingodb.sdk.service.entity.meta.ExportMetaRequest;
import io.dingodb.sdk.service.entity.meta.ExportMetaResponse;
import io.dingodb.sdk.service.entity.meta.GenerateAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.GenerateAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.GenerateTableIdsRequest;
import io.dingodb.sdk.service.entity.meta.GenerateTableIdsResponse;
import io.dingodb.sdk.service.entity.meta.GetAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.GetAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.GetAutoIncrementsRequest;
import io.dingodb.sdk.service.entity.meta.GetAutoIncrementsResponse;
import io.dingodb.sdk.service.entity.meta.GetDeletedIndexRequest;
import io.dingodb.sdk.service.entity.meta.GetDeletedIndexResponse;
import io.dingodb.sdk.service.entity.meta.GetDeletedTableRequest;
import io.dingodb.sdk.service.entity.meta.GetDeletedTableResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexByNameRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexByNameResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexMetricsRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexMetricsResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexRangeRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexRangeResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexesCountRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexesCountResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexesRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexesResponse;
import io.dingodb.sdk.service.entity.meta.GetSchemaByNameRequest;
import io.dingodb.sdk.service.entity.meta.GetSchemaByNameResponse;
import io.dingodb.sdk.service.entity.meta.GetSchemaRequest;
import io.dingodb.sdk.service.entity.meta.GetSchemaResponse;
import io.dingodb.sdk.service.entity.meta.GetSchemasRequest;
import io.dingodb.sdk.service.entity.meta.GetSchemasResponse;
import io.dingodb.sdk.service.entity.meta.GetTableByNameRequest;
import io.dingodb.sdk.service.entity.meta.GetTableByNameResponse;
import io.dingodb.sdk.service.entity.meta.GetTableMetricsRequest;
import io.dingodb.sdk.service.entity.meta.GetTableMetricsResponse;
import io.dingodb.sdk.service.entity.meta.GetTableRangeRequest;
import io.dingodb.sdk.service.entity.meta.GetTableRangeResponse;
import io.dingodb.sdk.service.entity.meta.GetTableRequest;
import io.dingodb.sdk.service.entity.meta.GetTableResponse;
import io.dingodb.sdk.service.entity.meta.GetTablesBySchemaRequest;
import io.dingodb.sdk.service.entity.meta.GetTablesBySchemaResponse;
import io.dingodb.sdk.service.entity.meta.GetTablesCountRequest;
import io.dingodb.sdk.service.entity.meta.GetTablesCountResponse;
import io.dingodb.sdk.service.entity.meta.GetTablesRequest;
import io.dingodb.sdk.service.entity.meta.GetTablesResponse;
import io.dingodb.sdk.service.entity.meta.GetTenantsRequest;
import io.dingodb.sdk.service.entity.meta.GetTenantsResponse;
import io.dingodb.sdk.service.entity.meta.HelloRequest;
import io.dingodb.sdk.service.entity.meta.HelloResponse;
import io.dingodb.sdk.service.entity.meta.ImportIdEpochTypeRequest;
import io.dingodb.sdk.service.entity.meta.ImportIdEpochTypeResponse;
import io.dingodb.sdk.service.entity.meta.ImportMetaRequest;
import io.dingodb.sdk.service.entity.meta.ImportMetaResponse;
import io.dingodb.sdk.service.entity.meta.ListWatchRequest;
import io.dingodb.sdk.service.entity.meta.ListWatchResponse;
import io.dingodb.sdk.service.entity.meta.SaveIdEpochTypeRequest;
import io.dingodb.sdk.service.entity.meta.SaveIdEpochTypeResponse;
import io.dingodb.sdk.service.entity.meta.SwitchAutoSplitRequest;
import io.dingodb.sdk.service.entity.meta.SwitchAutoSplitResponse;
import io.dingodb.sdk.service.entity.meta.TsoRequest;
import io.dingodb.sdk.service.entity.meta.TsoResponse;
import io.dingodb.sdk.service.entity.meta.UpdateAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.UpdateAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.UpdateIndexRequest;
import io.dingodb.sdk.service.entity.meta.UpdateIndexResponse;
import io.dingodb.sdk.service.entity.meta.UpdateTablesRequest;
import io.dingodb.sdk.service.entity.meta.UpdateTablesResponse;
import io.dingodb.sdk.service.entity.meta.UpdateTenantRequest;
import io.dingodb.sdk.service.entity.meta.UpdateTenantResponse;
import io.dingodb.sdk.service.entity.meta.WatchRequest;
import io.dingodb.sdk.service.entity.meta.WatchResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MetaServiceDescriptors {
    MethodDescriptor<HelloRequest, HelloResponse> hello = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/Hello", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> helloHandlers = new ServiceCallCycles<>(hello, Hello.logger);

    MethodDescriptor<HelloRequest, HelloResponse> getMemoryInfo = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetMemoryInfo", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> getMemoryInfoHandlers = new ServiceCallCycles<>(getMemoryInfo, GetMemoryInfo.logger);

    MethodDescriptor<TsoRequest, TsoResponse> getTsoInfo = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetTsoInfo", TsoRequest::new, TsoResponse::new);

    ServiceCallCycles<TsoRequest, TsoResponse> getTsoInfoHandlers = new ServiceCallCycles<>(getTsoInfo, GetTsoInfo.logger);

    MethodDescriptor<GetSchemasRequest, GetSchemasResponse> getSchemas = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetSchemas", GetSchemasRequest::new, GetSchemasResponse::new);

    ServiceCallCycles<GetSchemasRequest, GetSchemasResponse> getSchemasHandlers = new ServiceCallCycles<>(getSchemas, GetSchemas.logger);

    MethodDescriptor<GetSchemaRequest, GetSchemaResponse> getSchema = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetSchema", GetSchemaRequest::new, GetSchemaResponse::new);

    ServiceCallCycles<GetSchemaRequest, GetSchemaResponse> getSchemaHandlers = new ServiceCallCycles<>(getSchema, GetSchema.logger);

    MethodDescriptor<GetSchemaByNameRequest, GetSchemaByNameResponse> getSchemaByName = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetSchemaByName", GetSchemaByNameRequest::new, GetSchemaByNameResponse::new);

    ServiceCallCycles<GetSchemaByNameRequest, GetSchemaByNameResponse> getSchemaByNameHandlers = new ServiceCallCycles<>(getSchemaByName, GetSchemaByName.logger);

    MethodDescriptor<GetTablesBySchemaRequest, GetTablesBySchemaResponse> getTablesBySchema = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetTablesBySchema", GetTablesBySchemaRequest::new, GetTablesBySchemaResponse::new);

    ServiceCallCycles<GetTablesBySchemaRequest, GetTablesBySchemaResponse> getTablesBySchemaHandlers = new ServiceCallCycles<>(getTablesBySchema, GetTablesBySchema.logger);

    MethodDescriptor<GetTablesCountRequest, GetTablesCountResponse> getTablesCount = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetTablesCount", GetTablesCountRequest::new, GetTablesCountResponse::new);

    ServiceCallCycles<GetTablesCountRequest, GetTablesCountResponse> getTablesCountHandlers = new ServiceCallCycles<>(getTablesCount, GetTablesCount.logger);

    MethodDescriptor<GetTableRequest, GetTableResponse> getTable = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetTable", GetTableRequest::new, GetTableResponse::new);

    ServiceCallCycles<GetTableRequest, GetTableResponse> getTableHandlers = new ServiceCallCycles<>(getTable, GetTable.logger);

    MethodDescriptor<GetTableByNameRequest, GetTableByNameResponse> getTableByName = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetTableByName", GetTableByNameRequest::new, GetTableByNameResponse::new);

    ServiceCallCycles<GetTableByNameRequest, GetTableByNameResponse> getTableByNameHandlers = new ServiceCallCycles<>(getTableByName, GetTableByName.logger);

    MethodDescriptor<GetTableRangeRequest, GetTableRangeResponse> getTableRange = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetTableRange", GetTableRangeRequest::new, GetTableRangeResponse::new);

    ServiceCallCycles<GetTableRangeRequest, GetTableRangeResponse> getTableRangeHandlers = new ServiceCallCycles<>(getTableRange, GetTableRange.logger);

    MethodDescriptor<GetTableMetricsRequest, GetTableMetricsResponse> getTableMetrics = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetTableMetrics", GetTableMetricsRequest::new, GetTableMetricsResponse::new);

    ServiceCallCycles<GetTableMetricsRequest, GetTableMetricsResponse> getTableMetricsHandlers = new ServiceCallCycles<>(getTableMetrics, GetTableMetrics.logger);

    MethodDescriptor<CreateTableIdRequest, CreateTableIdResponse> createTableId = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateTableId", CreateTableIdRequest::new, CreateTableIdResponse::new);

    ServiceCallCycles<CreateTableIdRequest, CreateTableIdResponse> createTableIdHandlers = new ServiceCallCycles<>(createTableId, CreateTableId.logger);

    MethodDescriptor<CreateTableIdsRequest, CreateTableIdsResponse> createTableIds = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateTableIds", CreateTableIdsRequest::new, CreateTableIdsResponse::new);

    ServiceCallCycles<CreateTableIdsRequest, CreateTableIdsResponse> createTableIdsHandlers = new ServiceCallCycles<>(createTableIds, CreateTableIds.logger);

    MethodDescriptor<CreateTableRequest, CreateTableResponse> createTable = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateTable", CreateTableRequest::new, CreateTableResponse::new);

    ServiceCallCycles<CreateTableRequest, CreateTableResponse> createTableHandlers = new ServiceCallCycles<>(createTable, CreateTable.logger);

    MethodDescriptor<DropTableRequest, DropTableResponse> dropTable = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/DropTable", DropTableRequest::new, DropTableResponse::new);

    ServiceCallCycles<DropTableRequest, DropTableResponse> dropTableHandlers = new ServiceCallCycles<>(dropTable, DropTable.logger);

    MethodDescriptor<GenerateTableIdsRequest, GenerateTableIdsResponse> generateTableIds = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GenerateTableIds", GenerateTableIdsRequest::new, GenerateTableIdsResponse::new);

    ServiceCallCycles<GenerateTableIdsRequest, GenerateTableIdsResponse> generateTableIdsHandlers = new ServiceCallCycles<>(generateTableIds, GenerateTableIds.logger);

    MethodDescriptor<CreateTablesRequest, CreateTablesResponse> createTables = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateTables", CreateTablesRequest::new, CreateTablesResponse::new);

    ServiceCallCycles<CreateTablesRequest, CreateTablesResponse> createTablesHandlers = new ServiceCallCycles<>(createTables, CreateTables.logger);

    MethodDescriptor<UpdateTablesRequest, UpdateTablesResponse> updateTables = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/UpdateTables", UpdateTablesRequest::new, UpdateTablesResponse::new);

    ServiceCallCycles<UpdateTablesRequest, UpdateTablesResponse> updateTablesHandlers = new ServiceCallCycles<>(updateTables, UpdateTables.logger);

    MethodDescriptor<AddIndexOnTableRequest, AddIndexOnTableResponse> addIndexOnTable = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/AddIndexOnTable", AddIndexOnTableRequest::new, AddIndexOnTableResponse::new);

    ServiceCallCycles<AddIndexOnTableRequest, AddIndexOnTableResponse> addIndexOnTableHandlers = new ServiceCallCycles<>(addIndexOnTable, AddIndexOnTable.logger);

    MethodDescriptor<DropIndexOnTableRequest, DropIndexOnTableResponse> dropIndexOnTable = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/DropIndexOnTable", DropIndexOnTableRequest::new, DropIndexOnTableResponse::new);

    ServiceCallCycles<DropIndexOnTableRequest, DropIndexOnTableResponse> dropIndexOnTableHandlers = new ServiceCallCycles<>(dropIndexOnTable, DropIndexOnTable.logger);

    MethodDescriptor<GetTablesRequest, GetTablesResponse> getTables = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetTables", GetTablesRequest::new, GetTablesResponse::new);

    ServiceCallCycles<GetTablesRequest, GetTablesResponse> getTablesHandlers = new ServiceCallCycles<>(getTables, GetTables.logger);

    MethodDescriptor<DropTablesRequest, DropTablesResponse> dropTables = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/DropTables", DropTablesRequest::new, DropTablesResponse::new);

    ServiceCallCycles<DropTablesRequest, DropTablesResponse> dropTablesHandlers = new ServiceCallCycles<>(dropTables, DropTables.logger);

    MethodDescriptor<GetIndexesRequest, GetIndexesResponse> getIndexes = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetIndexes", GetIndexesRequest::new, GetIndexesResponse::new);

    ServiceCallCycles<GetIndexesRequest, GetIndexesResponse> getIndexesHandlers = new ServiceCallCycles<>(getIndexes, GetIndexes.logger);

    MethodDescriptor<GetIndexesCountRequest, GetIndexesCountResponse> getIndexesCount = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetIndexesCount", GetIndexesCountRequest::new, GetIndexesCountResponse::new);

    ServiceCallCycles<GetIndexesCountRequest, GetIndexesCountResponse> getIndexesCountHandlers = new ServiceCallCycles<>(getIndexesCount, GetIndexesCount.logger);

    MethodDescriptor<GetIndexRequest, GetIndexResponse> getIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetIndex", GetIndexRequest::new, GetIndexResponse::new);

    ServiceCallCycles<GetIndexRequest, GetIndexResponse> getIndexHandlers = new ServiceCallCycles<>(getIndex, GetIndex.logger);

    MethodDescriptor<GetIndexByNameRequest, GetIndexByNameResponse> getIndexByName = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetIndexByName", GetIndexByNameRequest::new, GetIndexByNameResponse::new);

    ServiceCallCycles<GetIndexByNameRequest, GetIndexByNameResponse> getIndexByNameHandlers = new ServiceCallCycles<>(getIndexByName, GetIndexByName.logger);

    MethodDescriptor<GetIndexRangeRequest, GetIndexRangeResponse> getIndexRange = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetIndexRange", GetIndexRangeRequest::new, GetIndexRangeResponse::new);

    ServiceCallCycles<GetIndexRangeRequest, GetIndexRangeResponse> getIndexRangeHandlers = new ServiceCallCycles<>(getIndexRange, GetIndexRange.logger);

    MethodDescriptor<GetIndexMetricsRequest, GetIndexMetricsResponse> getIndexMetrics = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetIndexMetrics", GetIndexMetricsRequest::new, GetIndexMetricsResponse::new);

    ServiceCallCycles<GetIndexMetricsRequest, GetIndexMetricsResponse> getIndexMetricsHandlers = new ServiceCallCycles<>(getIndexMetrics, GetIndexMetrics.logger);

    MethodDescriptor<CreateIndexIdRequest, CreateIndexIdResponse> createIndexId = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateIndexId", CreateIndexIdRequest::new, CreateIndexIdResponse::new);

    ServiceCallCycles<CreateIndexIdRequest, CreateIndexIdResponse> createIndexIdHandlers = new ServiceCallCycles<>(createIndexId, CreateIndexId.logger);

    MethodDescriptor<CreateIndexRequest, CreateIndexResponse> createIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateIndex", CreateIndexRequest::new, CreateIndexResponse::new);

    ServiceCallCycles<CreateIndexRequest, CreateIndexResponse> createIndexHandlers = new ServiceCallCycles<>(createIndex, CreateIndex.logger);

    MethodDescriptor<UpdateIndexRequest, UpdateIndexResponse> updateIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/UpdateIndex", UpdateIndexRequest::new, UpdateIndexResponse::new);

    ServiceCallCycles<UpdateIndexRequest, UpdateIndexResponse> updateIndexHandlers = new ServiceCallCycles<>(updateIndex, UpdateIndex.logger);

    MethodDescriptor<DropIndexRequest, DropIndexResponse> dropIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/DropIndex", DropIndexRequest::new, DropIndexResponse::new);

    ServiceCallCycles<DropIndexRequest, DropIndexResponse> dropIndexHandlers = new ServiceCallCycles<>(dropIndex, DropIndex.logger);

    MethodDescriptor<CreateSchemaRequest, CreateSchemaResponse> createSchema = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateSchema", CreateSchemaRequest::new, CreateSchemaResponse::new);

    ServiceCallCycles<CreateSchemaRequest, CreateSchemaResponse> createSchemaHandlers = new ServiceCallCycles<>(createSchema, CreateSchema.logger);

    MethodDescriptor<DropSchemaRequest, DropSchemaResponse> dropSchema = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/DropSchema", DropSchemaRequest::new, DropSchemaResponse::new);

    ServiceCallCycles<DropSchemaRequest, DropSchemaResponse> dropSchemaHandlers = new ServiceCallCycles<>(dropSchema, DropSchema.logger);

    MethodDescriptor<GetAutoIncrementsRequest, GetAutoIncrementsResponse> getAutoIncrements = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetAutoIncrements", GetAutoIncrementsRequest::new, GetAutoIncrementsResponse::new);

    ServiceCallCycles<GetAutoIncrementsRequest, GetAutoIncrementsResponse> getAutoIncrementsHandlers = new ServiceCallCycles<>(getAutoIncrements, GetAutoIncrements.logger);

    MethodDescriptor<GetAutoIncrementRequest, GetAutoIncrementResponse> getAutoIncrement = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetAutoIncrement", GetAutoIncrementRequest::new, GetAutoIncrementResponse::new);

    ServiceCallCycles<GetAutoIncrementRequest, GetAutoIncrementResponse> getAutoIncrementHandlers = new ServiceCallCycles<>(getAutoIncrement, GetAutoIncrement.logger);

    MethodDescriptor<CreateAutoIncrementRequest, CreateAutoIncrementResponse> createAutoIncrement = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateAutoIncrement", CreateAutoIncrementRequest::new, CreateAutoIncrementResponse::new);

    ServiceCallCycles<CreateAutoIncrementRequest, CreateAutoIncrementResponse> createAutoIncrementHandlers = new ServiceCallCycles<>(createAutoIncrement, CreateAutoIncrement.logger);

    MethodDescriptor<CreateAutoIncrementsRequest, CreateAutoIncrementsResponse> createAutoIncrements = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateAutoIncrements", CreateAutoIncrementsRequest::new, CreateAutoIncrementsResponse::new);

    ServiceCallCycles<CreateAutoIncrementsRequest, CreateAutoIncrementsResponse> createAutoIncrementsHandlers = new ServiceCallCycles<>(createAutoIncrements, CreateAutoIncrements.logger);

    MethodDescriptor<UpdateAutoIncrementRequest, UpdateAutoIncrementResponse> updateAutoIncrement = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/UpdateAutoIncrement", UpdateAutoIncrementRequest::new, UpdateAutoIncrementResponse::new);

    ServiceCallCycles<UpdateAutoIncrementRequest, UpdateAutoIncrementResponse> updateAutoIncrementHandlers = new ServiceCallCycles<>(updateAutoIncrement, UpdateAutoIncrement.logger);

    MethodDescriptor<GenerateAutoIncrementRequest, GenerateAutoIncrementResponse> generateAutoIncrement = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GenerateAutoIncrement", GenerateAutoIncrementRequest::new, GenerateAutoIncrementResponse::new);

    ServiceCallCycles<GenerateAutoIncrementRequest, GenerateAutoIncrementResponse> generateAutoIncrementHandlers = new ServiceCallCycles<>(generateAutoIncrement, GenerateAutoIncrement.logger);

    MethodDescriptor<DeleteAutoIncrementRequest, DeleteAutoIncrementResponse> deleteAutoIncrement = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/DeleteAutoIncrement", DeleteAutoIncrementRequest::new, DeleteAutoIncrementResponse::new);

    ServiceCallCycles<DeleteAutoIncrementRequest, DeleteAutoIncrementResponse> deleteAutoIncrementHandlers = new ServiceCallCycles<>(deleteAutoIncrement, DeleteAutoIncrement.logger);

    MethodDescriptor<SwitchAutoSplitRequest, SwitchAutoSplitResponse> switchAutoSplit = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/SwitchAutoSplit", SwitchAutoSplitRequest::new, SwitchAutoSplitResponse::new);

    ServiceCallCycles<SwitchAutoSplitRequest, SwitchAutoSplitResponse> switchAutoSplitHandlers = new ServiceCallCycles<>(switchAutoSplit, SwitchAutoSplit.logger);

    MethodDescriptor<TsoRequest, TsoResponse> tsoService = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/TsoService", TsoRequest::new, TsoResponse::new);

    ServiceCallCycles<TsoRequest, TsoResponse> tsoServiceHandlers = new ServiceCallCycles<>(tsoService, TsoService.logger);

    MethodDescriptor<GetDeletedTableRequest, GetDeletedTableResponse> getDeletedTable = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetDeletedTable", GetDeletedTableRequest::new, GetDeletedTableResponse::new);

    ServiceCallCycles<GetDeletedTableRequest, GetDeletedTableResponse> getDeletedTableHandlers = new ServiceCallCycles<>(getDeletedTable, GetDeletedTable.logger);

    MethodDescriptor<CleanDeletedTableRequest, CleanDeletedTableResponse> cleanDeletedTable = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CleanDeletedTable", CleanDeletedTableRequest::new, CleanDeletedTableResponse::new);

    ServiceCallCycles<CleanDeletedTableRequest, CleanDeletedTableResponse> cleanDeletedTableHandlers = new ServiceCallCycles<>(cleanDeletedTable, CleanDeletedTable.logger);

    MethodDescriptor<GetDeletedIndexRequest, GetDeletedIndexResponse> getDeletedIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetDeletedIndex", GetDeletedIndexRequest::new, GetDeletedIndexResponse::new);

    ServiceCallCycles<GetDeletedIndexRequest, GetDeletedIndexResponse> getDeletedIndexHandlers = new ServiceCallCycles<>(getDeletedIndex, GetDeletedIndex.logger);

    MethodDescriptor<CleanDeletedIndexRequest, CleanDeletedIndexResponse> cleanDeletedIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CleanDeletedIndex", CleanDeletedIndexRequest::new, CleanDeletedIndexResponse::new);

    ServiceCallCycles<CleanDeletedIndexRequest, CleanDeletedIndexResponse> cleanDeletedIndexHandlers = new ServiceCallCycles<>(cleanDeletedIndex, CleanDeletedIndex.logger);

    MethodDescriptor<WatchRequest, WatchResponse> watch = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/Watch", WatchRequest::new, WatchResponse::new);

    ServiceCallCycles<WatchRequest, WatchResponse> watchHandlers = new ServiceCallCycles<>(watch, Watch.logger);

    MethodDescriptor<ListWatchRequest, ListWatchResponse> listWatch = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/ListWatch", ListWatchRequest::new, ListWatchResponse::new);

    ServiceCallCycles<ListWatchRequest, ListWatchResponse> listWatchHandlers = new ServiceCallCycles<>(listWatch, ListWatch.logger);

    MethodDescriptor<CreateTenantRequest, CreateTenantResponse> createTenant = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateTenant", CreateTenantRequest::new, CreateTenantResponse::new);

    ServiceCallCycles<CreateTenantRequest, CreateTenantResponse> createTenantHandlers = new ServiceCallCycles<>(createTenant, CreateTenant.logger);

    MethodDescriptor<DropTenantRequest, DropTenantResponse> dropTenant = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/DropTenant", DropTenantRequest::new, DropTenantResponse::new);

    ServiceCallCycles<DropTenantRequest, DropTenantResponse> dropTenantHandlers = new ServiceCallCycles<>(dropTenant, DropTenant.logger);

    MethodDescriptor<UpdateTenantRequest, UpdateTenantResponse> updateTenant = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/UpdateTenant", UpdateTenantRequest::new, UpdateTenantResponse::new);

    ServiceCallCycles<UpdateTenantRequest, UpdateTenantResponse> updateTenantHandlers = new ServiceCallCycles<>(updateTenant, UpdateTenant.logger);

    MethodDescriptor<GetTenantsRequest, GetTenantsResponse> getTenants = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/GetTenants", GetTenantsRequest::new, GetTenantsResponse::new);

    ServiceCallCycles<GetTenantsRequest, GetTenantsResponse> getTenantsHandlers = new ServiceCallCycles<>(getTenants, GetTenants.logger);

    MethodDescriptor<ExportMetaRequest, ExportMetaResponse> exportMeta = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/ExportMeta", ExportMetaRequest::new, ExportMetaResponse::new);

    ServiceCallCycles<ExportMetaRequest, ExportMetaResponse> exportMetaHandlers = new ServiceCallCycles<>(exportMeta, ExportMeta.logger);

    MethodDescriptor<SaveIdEpochTypeRequest, SaveIdEpochTypeResponse> saveIdEpochType = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/SaveIdEpochType", SaveIdEpochTypeRequest::new, SaveIdEpochTypeResponse::new);

    ServiceCallCycles<SaveIdEpochTypeRequest, SaveIdEpochTypeResponse> saveIdEpochTypeHandlers = new ServiceCallCycles<>(saveIdEpochType, SaveIdEpochType.logger);

    MethodDescriptor<ImportMetaRequest, ImportMetaResponse> importMeta = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/ImportMeta", ImportMetaRequest::new, ImportMetaResponse::new);

    ServiceCallCycles<ImportMetaRequest, ImportMetaResponse> importMetaHandlers = new ServiceCallCycles<>(importMeta, ImportMeta.logger);

    MethodDescriptor<ImportIdEpochTypeRequest, ImportIdEpochTypeResponse> importIdEpochType = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/ImportIdEpochType", ImportIdEpochTypeRequest::new, ImportIdEpochTypeResponse::new);

    ServiceCallCycles<ImportIdEpochTypeRequest, ImportIdEpochTypeResponse> importIdEpochTypeHandlers = new ServiceCallCycles<>(importIdEpochType, ImportIdEpochType.logger);

    MethodDescriptor<CreateOrUpdateAutoIncrementsRequest, CreateOrUpdateAutoIncrementsResponse> createOrUpdateAutoIncrements = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateOrUpdateAutoIncrements", CreateOrUpdateAutoIncrementsRequest::new, CreateOrUpdateAutoIncrementsResponse::new);

    ServiceCallCycles<CreateOrUpdateAutoIncrementsRequest, CreateOrUpdateAutoIncrementsResponse> createOrUpdateAutoIncrementsHandlers = new ServiceCallCycles<>(createOrUpdateAutoIncrements, CreateOrUpdateAutoIncrements.logger);

    MethodDescriptor<CreateTenantsRequest, CreateTenantsResponse> createTenants = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateTenants", CreateTenantsRequest::new, CreateTenantsResponse::new);

    ServiceCallCycles<CreateTenantsRequest, CreateTenantsResponse> createTenantsHandlers = new ServiceCallCycles<>(createTenants, CreateTenants.logger);

    MethodDescriptor<CreateSchemasRequest, CreateSchemasResponse> createSchemas = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateSchemas", CreateSchemasRequest::new, CreateSchemasResponse::new);

    ServiceCallCycles<CreateSchemasRequest, CreateSchemasResponse> createSchemasHandlers = new ServiceCallCycles<>(createSchemas, CreateSchemas.logger);

    MethodDescriptor<CreateIndexMetasRequest, CreateIndexMetasResponse> createIndexMetas = ServiceMethodBuilder.buildUnary("dingodb.pb.meta.MetaService/CreateIndexMetas", CreateIndexMetasRequest::new, CreateIndexMetasResponse::new);

    ServiceCallCycles<CreateIndexMetasRequest, CreateIndexMetasResponse> createIndexMetasHandlers = new ServiceCallCycles<>(createIndexMetas, CreateIndexMetas.logger);

    final class Hello {
        public static final Logger logger = LoggerFactory.getLogger(Hello.class);
    }

    final class GetMemoryInfo {
        public static final Logger logger = LoggerFactory.getLogger(GetMemoryInfo.class);
    }

    final class GetTsoInfo {
        public static final Logger logger = LoggerFactory.getLogger(GetTsoInfo.class);
    }

    final class GetSchemas {
        public static final Logger logger = LoggerFactory.getLogger(GetSchemas.class);
    }

    final class GetSchema {
        public static final Logger logger = LoggerFactory.getLogger(GetSchema.class);
    }

    final class GetSchemaByName {
        public static final Logger logger = LoggerFactory.getLogger(GetSchemaByName.class);
    }

    final class GetTablesBySchema {
        public static final Logger logger = LoggerFactory.getLogger(GetTablesBySchema.class);
    }

    final class GetTablesCount {
        public static final Logger logger = LoggerFactory.getLogger(GetTablesCount.class);
    }

    final class GetTable {
        public static final Logger logger = LoggerFactory.getLogger(GetTable.class);
    }

    final class GetTableByName {
        public static final Logger logger = LoggerFactory.getLogger(GetTableByName.class);
    }

    final class GetTableRange {
        public static final Logger logger = LoggerFactory.getLogger(GetTableRange.class);
    }

    final class GetTableMetrics {
        public static final Logger logger = LoggerFactory.getLogger(GetTableMetrics.class);
    }

    final class CreateTableId {
        public static final Logger logger = LoggerFactory.getLogger(CreateTableId.class);
    }

    final class CreateTableIds {
        public static final Logger logger = LoggerFactory.getLogger(CreateTableIds.class);
    }

    final class CreateTable {
        public static final Logger logger = LoggerFactory.getLogger(CreateTable.class);
    }

    final class DropTable {
        public static final Logger logger = LoggerFactory.getLogger(DropTable.class);
    }

    final class GenerateTableIds {
        public static final Logger logger = LoggerFactory.getLogger(GenerateTableIds.class);
    }

    final class CreateTables {
        public static final Logger logger = LoggerFactory.getLogger(CreateTables.class);
    }

    final class UpdateTables {
        public static final Logger logger = LoggerFactory.getLogger(UpdateTables.class);
    }

    final class AddIndexOnTable {
        public static final Logger logger = LoggerFactory.getLogger(AddIndexOnTable.class);
    }

    final class DropIndexOnTable {
        public static final Logger logger = LoggerFactory.getLogger(DropIndexOnTable.class);
    }

    final class GetTables {
        public static final Logger logger = LoggerFactory.getLogger(GetTables.class);
    }

    final class DropTables {
        public static final Logger logger = LoggerFactory.getLogger(DropTables.class);
    }

    final class GetIndexes {
        public static final Logger logger = LoggerFactory.getLogger(GetIndexes.class);
    }

    final class GetIndexesCount {
        public static final Logger logger = LoggerFactory.getLogger(GetIndexesCount.class);
    }

    final class GetIndex {
        public static final Logger logger = LoggerFactory.getLogger(GetIndex.class);
    }

    final class GetIndexByName {
        public static final Logger logger = LoggerFactory.getLogger(GetIndexByName.class);
    }

    final class GetIndexRange {
        public static final Logger logger = LoggerFactory.getLogger(GetIndexRange.class);
    }

    final class GetIndexMetrics {
        public static final Logger logger = LoggerFactory.getLogger(GetIndexMetrics.class);
    }

    final class CreateIndexId {
        public static final Logger logger = LoggerFactory.getLogger(CreateIndexId.class);
    }

    final class CreateIndex {
        public static final Logger logger = LoggerFactory.getLogger(CreateIndex.class);
    }

    final class UpdateIndex {
        public static final Logger logger = LoggerFactory.getLogger(UpdateIndex.class);
    }

    final class DropIndex {
        public static final Logger logger = LoggerFactory.getLogger(DropIndex.class);
    }

    final class CreateSchema {
        public static final Logger logger = LoggerFactory.getLogger(CreateSchema.class);
    }

    final class DropSchema {
        public static final Logger logger = LoggerFactory.getLogger(DropSchema.class);
    }

    final class GetAutoIncrements {
        public static final Logger logger = LoggerFactory.getLogger(GetAutoIncrements.class);
    }

    final class GetAutoIncrement {
        public static final Logger logger = LoggerFactory.getLogger(GetAutoIncrement.class);
    }

    final class CreateAutoIncrement {
        public static final Logger logger = LoggerFactory.getLogger(CreateAutoIncrement.class);
    }

    final class CreateAutoIncrements {
        public static final Logger logger = LoggerFactory.getLogger(CreateAutoIncrements.class);
    }

    final class UpdateAutoIncrement {
        public static final Logger logger = LoggerFactory.getLogger(UpdateAutoIncrement.class);
    }

    final class GenerateAutoIncrement {
        public static final Logger logger = LoggerFactory.getLogger(GenerateAutoIncrement.class);
    }

    final class DeleteAutoIncrement {
        public static final Logger logger = LoggerFactory.getLogger(DeleteAutoIncrement.class);
    }

    final class SwitchAutoSplit {
        public static final Logger logger = LoggerFactory.getLogger(SwitchAutoSplit.class);
    }

    final class TsoService {
        public static final Logger logger = LoggerFactory.getLogger(TsoService.class);
    }

    final class GetDeletedTable {
        public static final Logger logger = LoggerFactory.getLogger(GetDeletedTable.class);
    }

    final class CleanDeletedTable {
        public static final Logger logger = LoggerFactory.getLogger(CleanDeletedTable.class);
    }

    final class GetDeletedIndex {
        public static final Logger logger = LoggerFactory.getLogger(GetDeletedIndex.class);
    }

    final class CleanDeletedIndex {
        public static final Logger logger = LoggerFactory.getLogger(CleanDeletedIndex.class);
    }

    final class Watch {
        public static final Logger logger = LoggerFactory.getLogger(Watch.class);
    }

    final class ListWatch {
        public static final Logger logger = LoggerFactory.getLogger(ListWatch.class);
    }

    final class CreateTenant {
        public static final Logger logger = LoggerFactory.getLogger(CreateTenant.class);
    }

    final class DropTenant {
        public static final Logger logger = LoggerFactory.getLogger(DropTenant.class);
    }

    final class UpdateTenant {
        public static final Logger logger = LoggerFactory.getLogger(UpdateTenant.class);
    }

    final class GetTenants {
        public static final Logger logger = LoggerFactory.getLogger(GetTenants.class);
    }

    final class ExportMeta {
        public static final Logger logger = LoggerFactory.getLogger(ExportMeta.class);
    }

    final class SaveIdEpochType {
        public static final Logger logger = LoggerFactory.getLogger(SaveIdEpochType.class);
    }

    final class ImportMeta {
        public static final Logger logger = LoggerFactory.getLogger(ImportMeta.class);
    }

    final class ImportIdEpochType {
        public static final Logger logger = LoggerFactory.getLogger(ImportIdEpochType.class);
    }

    final class CreateOrUpdateAutoIncrements {
        public static final Logger logger = LoggerFactory.getLogger(CreateOrUpdateAutoIncrements.class);
    }

    final class CreateTenants {
        public static final Logger logger = LoggerFactory.getLogger(CreateTenants.class);
    }

    final class CreateSchemas {
        public static final Logger logger = LoggerFactory.getLogger(CreateSchemas.class);
    }

    final class CreateIndexMetas {
        public static final Logger logger = LoggerFactory.getLogger(CreateIndexMetas.class);
    }
}
