package io.dingodb.sdk.service.desc.index;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.index.HelloRequest;
import io.dingodb.sdk.service.entity.index.HelloResponse;
import io.dingodb.sdk.service.entity.index.VectorAddRequest;
import io.dingodb.sdk.service.entity.index.VectorAddResponse;
import io.dingodb.sdk.service.entity.index.VectorBatchQueryRequest;
import io.dingodb.sdk.service.entity.index.VectorBatchQueryResponse;
import io.dingodb.sdk.service.entity.index.VectorBuildRequest;
import io.dingodb.sdk.service.entity.index.VectorBuildResponse;
import io.dingodb.sdk.service.entity.index.VectorCountMemoryRequest;
import io.dingodb.sdk.service.entity.index.VectorCountMemoryResponse;
import io.dingodb.sdk.service.entity.index.VectorCountRequest;
import io.dingodb.sdk.service.entity.index.VectorCountResponse;
import io.dingodb.sdk.service.entity.index.VectorDeleteRequest;
import io.dingodb.sdk.service.entity.index.VectorDeleteResponse;
import io.dingodb.sdk.service.entity.index.VectorDumpRequest;
import io.dingodb.sdk.service.entity.index.VectorDumpResponse;
import io.dingodb.sdk.service.entity.index.VectorGetBorderIdRequest;
import io.dingodb.sdk.service.entity.index.VectorGetBorderIdResponse;
import io.dingodb.sdk.service.entity.index.VectorGetRegionMetricsRequest;
import io.dingodb.sdk.service.entity.index.VectorGetRegionMetricsResponse;
import io.dingodb.sdk.service.entity.index.VectorImportRequest;
import io.dingodb.sdk.service.entity.index.VectorImportResponse;
import io.dingodb.sdk.service.entity.index.VectorLoadRequest;
import io.dingodb.sdk.service.entity.index.VectorLoadResponse;
import io.dingodb.sdk.service.entity.index.VectorResetRequest;
import io.dingodb.sdk.service.entity.index.VectorResetResponse;
import io.dingodb.sdk.service.entity.index.VectorScanQueryRequest;
import io.dingodb.sdk.service.entity.index.VectorScanQueryResponse;
import io.dingodb.sdk.service.entity.index.VectorSearchDebugRequest;
import io.dingodb.sdk.service.entity.index.VectorSearchDebugResponse;
import io.dingodb.sdk.service.entity.index.VectorSearchRequest;
import io.dingodb.sdk.service.entity.index.VectorSearchResponse;
import io.dingodb.sdk.service.entity.index.VectorStatusRequest;
import io.dingodb.sdk.service.entity.index.VectorStatusResponse;
import io.dingodb.sdk.service.entity.store.BackupDataRequest;
import io.dingodb.sdk.service.entity.store.BackupDataResponse;
import io.dingodb.sdk.service.entity.store.ControlConfigRequest;
import io.dingodb.sdk.service.entity.store.ControlConfigResponse;
import io.dingodb.sdk.service.entity.store.RestoreDataRequest;
import io.dingodb.sdk.service.entity.store.RestoreDataResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchGetRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchGetResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusRequest;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusResponse;
import io.dingodb.sdk.service.entity.store.TxnCommitRequest;
import io.dingodb.sdk.service.entity.store.TxnCommitResponse;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeRequest;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeResponse;
import io.dingodb.sdk.service.entity.store.TxnDumpRequest;
import io.dingodb.sdk.service.entity.store.TxnDumpResponse;
import io.dingodb.sdk.service.entity.store.TxnGcRequest;
import io.dingodb.sdk.service.entity.store.TxnGcResponse;
import io.dingodb.sdk.service.entity.store.TxnGetRequest;
import io.dingodb.sdk.service.entity.store.TxnGetResponse;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatRequest;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnPrewriteRequest;
import io.dingodb.sdk.service.entity.store.TxnPrewriteResponse;
import io.dingodb.sdk.service.entity.store.TxnResolveLockRequest;
import io.dingodb.sdk.service.entity.store.TxnResolveLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanLockRequest;
import io.dingodb.sdk.service.entity.store.TxnScanLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanRequest;
import io.dingodb.sdk.service.entity.store.TxnScanResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IndexServiceDescriptors {
    MethodDescriptor<HelloRequest, HelloResponse> hello = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/Hello", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> helloHandlers = new ServiceCallCycles<>(hello, Hello.logger);

    MethodDescriptor<HelloRequest, HelloResponse> getMemoryInfo = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/GetMemoryInfo", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> getMemoryInfoHandlers = new ServiceCallCycles<>(getMemoryInfo, GetMemoryInfo.logger);

    MethodDescriptor<VectorAddRequest, VectorAddResponse> vectorAdd = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorAdd", VectorAddRequest::new, VectorAddResponse::new);

    ServiceCallCycles<VectorAddRequest, VectorAddResponse> vectorAddHandlers = new ServiceCallCycles<>(vectorAdd, VectorAdd.logger);

    MethodDescriptor<VectorBatchQueryRequest, VectorBatchQueryResponse> vectorBatchQuery = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorBatchQuery", VectorBatchQueryRequest::new, VectorBatchQueryResponse::new);

    ServiceCallCycles<VectorBatchQueryRequest, VectorBatchQueryResponse> vectorBatchQueryHandlers = new ServiceCallCycles<>(vectorBatchQuery, VectorBatchQuery.logger);

    MethodDescriptor<VectorSearchRequest, VectorSearchResponse> vectorSearch = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorSearch", VectorSearchRequest::new, VectorSearchResponse::new);

    ServiceCallCycles<VectorSearchRequest, VectorSearchResponse> vectorSearchHandlers = new ServiceCallCycles<>(vectorSearch, VectorSearch.logger);

    MethodDescriptor<VectorDeleteRequest, VectorDeleteResponse> vectorDelete = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorDelete", VectorDeleteRequest::new, VectorDeleteResponse::new);

    ServiceCallCycles<VectorDeleteRequest, VectorDeleteResponse> vectorDeleteHandlers = new ServiceCallCycles<>(vectorDelete, VectorDelete.logger);

    MethodDescriptor<VectorGetBorderIdRequest, VectorGetBorderIdResponse> vectorGetBorderId = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorGetBorderId", VectorGetBorderIdRequest::new, VectorGetBorderIdResponse::new);

    ServiceCallCycles<VectorGetBorderIdRequest, VectorGetBorderIdResponse> vectorGetBorderIdHandlers = new ServiceCallCycles<>(vectorGetBorderId, VectorGetBorderId.logger);

    MethodDescriptor<VectorScanQueryRequest, VectorScanQueryResponse> vectorScanQuery = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorScanQuery", VectorScanQueryRequest::new, VectorScanQueryResponse::new);

    ServiceCallCycles<VectorScanQueryRequest, VectorScanQueryResponse> vectorScanQueryHandlers = new ServiceCallCycles<>(vectorScanQuery, VectorScanQuery.logger);

    MethodDescriptor<VectorGetRegionMetricsRequest, VectorGetRegionMetricsResponse> vectorGetRegionMetrics = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorGetRegionMetrics", VectorGetRegionMetricsRequest::new, VectorGetRegionMetricsResponse::new);

    ServiceCallCycles<VectorGetRegionMetricsRequest, VectorGetRegionMetricsResponse> vectorGetRegionMetricsHandlers = new ServiceCallCycles<>(vectorGetRegionMetrics, VectorGetRegionMetrics.logger);

    MethodDescriptor<VectorCountRequest, VectorCountResponse> vectorCount = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorCount", VectorCountRequest::new, VectorCountResponse::new);

    ServiceCallCycles<VectorCountRequest, VectorCountResponse> vectorCountHandlers = new ServiceCallCycles<>(vectorCount, VectorCount.logger);

    MethodDescriptor<VectorCountMemoryRequest, VectorCountMemoryResponse> vectorCountMemory = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorCountMemory", VectorCountMemoryRequest::new, VectorCountMemoryResponse::new);

    ServiceCallCycles<VectorCountMemoryRequest, VectorCountMemoryResponse> vectorCountMemoryHandlers = new ServiceCallCycles<>(vectorCountMemory, VectorCountMemory.logger);

    MethodDescriptor<VectorImportRequest, VectorImportResponse> vectorImport = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorImport", VectorImportRequest::new, VectorImportResponse::new);

    ServiceCallCycles<VectorImportRequest, VectorImportResponse> vectorImportHandlers = new ServiceCallCycles<>(vectorImport, VectorImport.logger);

    MethodDescriptor<VectorBuildRequest, VectorBuildResponse> vectorBuild = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorBuild", VectorBuildRequest::new, VectorBuildResponse::new);

    ServiceCallCycles<VectorBuildRequest, VectorBuildResponse> vectorBuildHandlers = new ServiceCallCycles<>(vectorBuild, VectorBuild.logger);

    MethodDescriptor<VectorLoadRequest, VectorLoadResponse> vectorLoad = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorLoad", VectorLoadRequest::new, VectorLoadResponse::new);

    ServiceCallCycles<VectorLoadRequest, VectorLoadResponse> vectorLoadHandlers = new ServiceCallCycles<>(vectorLoad, VectorLoad.logger);

    MethodDescriptor<VectorStatusRequest, VectorStatusResponse> vectorStatus = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorStatus", VectorStatusRequest::new, VectorStatusResponse::new);

    ServiceCallCycles<VectorStatusRequest, VectorStatusResponse> vectorStatusHandlers = new ServiceCallCycles<>(vectorStatus, VectorStatus.logger);

    MethodDescriptor<VectorResetRequest, VectorResetResponse> vectorReset = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorReset", VectorResetRequest::new, VectorResetResponse::new);

    ServiceCallCycles<VectorResetRequest, VectorResetResponse> vectorResetHandlers = new ServiceCallCycles<>(vectorReset, VectorReset.logger);

    MethodDescriptor<VectorDumpRequest, VectorDumpResponse> vectorDump = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorDump", VectorDumpRequest::new, VectorDumpResponse::new);

    ServiceCallCycles<VectorDumpRequest, VectorDumpResponse> vectorDumpHandlers = new ServiceCallCycles<>(vectorDump, VectorDump.logger);

    MethodDescriptor<VectorSearchDebugRequest, VectorSearchDebugResponse> vectorSearchDebug = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/VectorSearchDebug", VectorSearchDebugRequest::new, VectorSearchDebugResponse::new);

    ServiceCallCycles<VectorSearchDebugRequest, VectorSearchDebugResponse> vectorSearchDebugHandlers = new ServiceCallCycles<>(vectorSearchDebug, VectorSearchDebug.logger);

    MethodDescriptor<TxnGetRequest, TxnGetResponse> txnGet = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnGet", TxnGetRequest::new, TxnGetResponse::new);

    ServiceCallCycles<TxnGetRequest, TxnGetResponse> txnGetHandlers = new ServiceCallCycles<>(txnGet, TxnGet.logger);

    MethodDescriptor<TxnBatchGetRequest, TxnBatchGetResponse> txnBatchGet = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnBatchGet", TxnBatchGetRequest::new, TxnBatchGetResponse::new);

    ServiceCallCycles<TxnBatchGetRequest, TxnBatchGetResponse> txnBatchGetHandlers = new ServiceCallCycles<>(txnBatchGet, TxnBatchGet.logger);

    MethodDescriptor<TxnScanRequest, TxnScanResponse> txnScan = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnScan", TxnScanRequest::new, TxnScanResponse::new);

    ServiceCallCycles<TxnScanRequest, TxnScanResponse> txnScanHandlers = new ServiceCallCycles<>(txnScan, TxnScan.logger);

    MethodDescriptor<TxnScanLockRequest, TxnScanLockResponse> txnScanLock = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnScanLock", TxnScanLockRequest::new, TxnScanLockResponse::new);

    ServiceCallCycles<TxnScanLockRequest, TxnScanLockResponse> txnScanLockHandlers = new ServiceCallCycles<>(txnScanLock, TxnScanLock.logger);

    MethodDescriptor<TxnDumpRequest, TxnDumpResponse> txnDump = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnDump", TxnDumpRequest::new, TxnDumpResponse::new);

    ServiceCallCycles<TxnDumpRequest, TxnDumpResponse> txnDumpHandlers = new ServiceCallCycles<>(txnDump, TxnDump.logger);

    MethodDescriptor<TxnPessimisticLockRequest, TxnPessimisticLockResponse> txnPessimisticLock = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnPessimisticLock", TxnPessimisticLockRequest::new, TxnPessimisticLockResponse::new);

    ServiceCallCycles<TxnPessimisticLockRequest, TxnPessimisticLockResponse> txnPessimisticLockHandlers = new ServiceCallCycles<>(txnPessimisticLock, TxnPessimisticLock.logger);

    MethodDescriptor<TxnPessimisticRollbackRequest, TxnPessimisticRollbackResponse> txnPessimisticRollback = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnPessimisticRollback", TxnPessimisticRollbackRequest::new, TxnPessimisticRollbackResponse::new);

    ServiceCallCycles<TxnPessimisticRollbackRequest, TxnPessimisticRollbackResponse> txnPessimisticRollbackHandlers = new ServiceCallCycles<>(txnPessimisticRollback, TxnPessimisticRollback.logger);

    MethodDescriptor<TxnPrewriteRequest, TxnPrewriteResponse> txnPrewrite = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnPrewrite", TxnPrewriteRequest::new, TxnPrewriteResponse::new);

    ServiceCallCycles<TxnPrewriteRequest, TxnPrewriteResponse> txnPrewriteHandlers = new ServiceCallCycles<>(txnPrewrite, TxnPrewrite.logger);

    MethodDescriptor<TxnCommitRequest, TxnCommitResponse> txnCommit = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnCommit", TxnCommitRequest::new, TxnCommitResponse::new);

    ServiceCallCycles<TxnCommitRequest, TxnCommitResponse> txnCommitHandlers = new ServiceCallCycles<>(txnCommit, TxnCommit.logger);

    MethodDescriptor<TxnCheckTxnStatusRequest, TxnCheckTxnStatusResponse> txnCheckTxnStatus = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnCheckTxnStatus", TxnCheckTxnStatusRequest::new, TxnCheckTxnStatusResponse::new);

    ServiceCallCycles<TxnCheckTxnStatusRequest, TxnCheckTxnStatusResponse> txnCheckTxnStatusHandlers = new ServiceCallCycles<>(txnCheckTxnStatus, TxnCheckTxnStatus.logger);

    MethodDescriptor<TxnResolveLockRequest, TxnResolveLockResponse> txnResolveLock = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnResolveLock", TxnResolveLockRequest::new, TxnResolveLockResponse::new);

    ServiceCallCycles<TxnResolveLockRequest, TxnResolveLockResponse> txnResolveLockHandlers = new ServiceCallCycles<>(txnResolveLock, TxnResolveLock.logger);

    MethodDescriptor<TxnBatchRollbackRequest, TxnBatchRollbackResponse> txnBatchRollback = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnBatchRollback", TxnBatchRollbackRequest::new, TxnBatchRollbackResponse::new);

    ServiceCallCycles<TxnBatchRollbackRequest, TxnBatchRollbackResponse> txnBatchRollbackHandlers = new ServiceCallCycles<>(txnBatchRollback, TxnBatchRollback.logger);

    MethodDescriptor<TxnHeartBeatRequest, TxnHeartBeatResponse> txnHeartBeat = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnHeartBeat", TxnHeartBeatRequest::new, TxnHeartBeatResponse::new);

    ServiceCallCycles<TxnHeartBeatRequest, TxnHeartBeatResponse> txnHeartBeatHandlers = new ServiceCallCycles<>(txnHeartBeat, TxnHeartBeat.logger);

    MethodDescriptor<TxnGcRequest, TxnGcResponse> txnGc = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnGc", TxnGcRequest::new, TxnGcResponse::new);

    ServiceCallCycles<TxnGcRequest, TxnGcResponse> txnGcHandlers = new ServiceCallCycles<>(txnGc, TxnGc.logger);

    MethodDescriptor<TxnDeleteRangeRequest, TxnDeleteRangeResponse> txnDeleteRange = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/TxnDeleteRange", TxnDeleteRangeRequest::new, TxnDeleteRangeResponse::new);

    ServiceCallCycles<TxnDeleteRangeRequest, TxnDeleteRangeResponse> txnDeleteRangeHandlers = new ServiceCallCycles<>(txnDeleteRange, TxnDeleteRange.logger);

    MethodDescriptor<BackupDataRequest, BackupDataResponse> backupData = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/BackupData", BackupDataRequest::new, BackupDataResponse::new);

    ServiceCallCycles<BackupDataRequest, BackupDataResponse> backupDataHandlers = new ServiceCallCycles<>(backupData, BackupData.logger);

    MethodDescriptor<ControlConfigRequest, ControlConfigResponse> controlConfig = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/ControlConfig", ControlConfigRequest::new, ControlConfigResponse::new);

    ServiceCallCycles<ControlConfigRequest, ControlConfigResponse> controlConfigHandlers = new ServiceCallCycles<>(controlConfig, ControlConfig.logger);

    MethodDescriptor<RestoreDataRequest, RestoreDataResponse> restoreData = ServiceMethodBuilder.buildUnary("dingodb.pb.index.IndexService/RestoreData", RestoreDataRequest::new, RestoreDataResponse::new);

    ServiceCallCycles<RestoreDataRequest, RestoreDataResponse> restoreDataHandlers = new ServiceCallCycles<>(restoreData, RestoreData.logger);

    final class Hello {
        public static final Logger logger = LoggerFactory.getLogger(Hello.class);
    }

    final class GetMemoryInfo {
        public static final Logger logger = LoggerFactory.getLogger(GetMemoryInfo.class);
    }

    final class VectorAdd {
        public static final Logger logger = LoggerFactory.getLogger(VectorAdd.class);
    }

    final class VectorBatchQuery {
        public static final Logger logger = LoggerFactory.getLogger(VectorBatchQuery.class);
    }

    final class VectorSearch {
        public static final Logger logger = LoggerFactory.getLogger(VectorSearch.class);
    }

    final class VectorDelete {
        public static final Logger logger = LoggerFactory.getLogger(VectorDelete.class);
    }

    final class VectorGetBorderId {
        public static final Logger logger = LoggerFactory.getLogger(VectorGetBorderId.class);
    }

    final class VectorScanQuery {
        public static final Logger logger = LoggerFactory.getLogger(VectorScanQuery.class);
    }

    final class VectorGetRegionMetrics {
        public static final Logger logger = LoggerFactory.getLogger(VectorGetRegionMetrics.class);
    }

    final class VectorCount {
        public static final Logger logger = LoggerFactory.getLogger(VectorCount.class);
    }

    final class VectorCountMemory {
        public static final Logger logger = LoggerFactory.getLogger(VectorCountMemory.class);
    }

    final class VectorImport {
        public static final Logger logger = LoggerFactory.getLogger(VectorImport.class);
    }

    final class VectorBuild {
        public static final Logger logger = LoggerFactory.getLogger(VectorBuild.class);
    }

    final class VectorLoad {
        public static final Logger logger = LoggerFactory.getLogger(VectorLoad.class);
    }

    final class VectorStatus {
        public static final Logger logger = LoggerFactory.getLogger(VectorStatus.class);
    }

    final class VectorReset {
        public static final Logger logger = LoggerFactory.getLogger(VectorReset.class);
    }

    final class VectorDump {
        public static final Logger logger = LoggerFactory.getLogger(VectorDump.class);
    }

    final class VectorSearchDebug {
        public static final Logger logger = LoggerFactory.getLogger(VectorSearchDebug.class);
    }

    final class TxnGet {
        public static final Logger logger = LoggerFactory.getLogger(TxnGet.class);
    }

    final class TxnBatchGet {
        public static final Logger logger = LoggerFactory.getLogger(TxnBatchGet.class);
    }

    final class TxnScan {
        public static final Logger logger = LoggerFactory.getLogger(TxnScan.class);
    }

    final class TxnScanLock {
        public static final Logger logger = LoggerFactory.getLogger(TxnScanLock.class);
    }

    final class TxnDump {
        public static final Logger logger = LoggerFactory.getLogger(TxnDump.class);
    }

    final class TxnPessimisticLock {
        public static final Logger logger = LoggerFactory.getLogger(TxnPessimisticLock.class);
    }

    final class TxnPessimisticRollback {
        public static final Logger logger = LoggerFactory.getLogger(TxnPessimisticRollback.class);
    }

    final class TxnPrewrite {
        public static final Logger logger = LoggerFactory.getLogger(TxnPrewrite.class);
    }

    final class TxnCommit {
        public static final Logger logger = LoggerFactory.getLogger(TxnCommit.class);
    }

    final class TxnCheckTxnStatus {
        public static final Logger logger = LoggerFactory.getLogger(TxnCheckTxnStatus.class);
    }

    final class TxnResolveLock {
        public static final Logger logger = LoggerFactory.getLogger(TxnResolveLock.class);
    }

    final class TxnBatchRollback {
        public static final Logger logger = LoggerFactory.getLogger(TxnBatchRollback.class);
    }

    final class TxnHeartBeat {
        public static final Logger logger = LoggerFactory.getLogger(TxnHeartBeat.class);
    }

    final class TxnGc {
        public static final Logger logger = LoggerFactory.getLogger(TxnGc.class);
    }

    final class TxnDeleteRange {
        public static final Logger logger = LoggerFactory.getLogger(TxnDeleteRange.class);
    }

    final class BackupData {
        public static final Logger logger = LoggerFactory.getLogger(BackupData.class);
    }

    final class ControlConfig {
        public static final Logger logger = LoggerFactory.getLogger(ControlConfig.class);
    }

    final class RestoreData {
        public static final Logger logger = LoggerFactory.getLogger(RestoreData.class);
    }
}
