package io.dingodb.sdk.service.desc.fileservice;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.fileservice.CleanFileReaderRequest;
import io.dingodb.sdk.service.entity.fileservice.CleanFileReaderResponse;
import io.dingodb.sdk.service.entity.fileservice.GetFileRequest;
import io.dingodb.sdk.service.entity.fileservice.GetFileResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FileServiceDescriptors {
    MethodDescriptor<GetFileRequest, GetFileResponse> getFile = ServiceMethodBuilder.buildUnary("dingodb.pb.fileservice.FileService/GetFile", GetFileRequest::new, GetFileResponse::new);

    ServiceCallCycles<GetFileRequest, GetFileResponse> getFileHandlers = new ServiceCallCycles<>(getFile, GetFile.logger);

    MethodDescriptor<CleanFileReaderRequest, CleanFileReaderResponse> cleanFileReader = ServiceMethodBuilder.buildUnary("dingodb.pb.fileservice.FileService/CleanFileReader", CleanFileReaderRequest::new, CleanFileReaderResponse::new);

    ServiceCallCycles<CleanFileReaderRequest, CleanFileReaderResponse> cleanFileReaderHandlers = new ServiceCallCycles<>(cleanFileReader, CleanFileReader.logger);

    final class GetFile {
        public static final Logger logger = LoggerFactory.getLogger(GetFile.class);
    }

    final class CleanFileReader {
        public static final Logger logger = LoggerFactory.getLogger(CleanFileReader.class);
    }
}
