package io.dingodb.sdk.service.desc.document;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.document.DocumentAddRequest;
import io.dingodb.sdk.service.entity.document.DocumentAddResponse;
import io.dingodb.sdk.service.entity.document.DocumentBatchQueryRequest;
import io.dingodb.sdk.service.entity.document.DocumentBatchQueryResponse;
import io.dingodb.sdk.service.entity.document.DocumentCountRequest;
import io.dingodb.sdk.service.entity.document.DocumentCountResponse;
import io.dingodb.sdk.service.entity.document.DocumentDeleteRequest;
import io.dingodb.sdk.service.entity.document.DocumentDeleteResponse;
import io.dingodb.sdk.service.entity.document.DocumentGetBorderIdRequest;
import io.dingodb.sdk.service.entity.document.DocumentGetBorderIdResponse;
import io.dingodb.sdk.service.entity.document.DocumentGetRegionMetricsRequest;
import io.dingodb.sdk.service.entity.document.DocumentGetRegionMetricsResponse;
import io.dingodb.sdk.service.entity.document.DocumentScanQueryRequest;
import io.dingodb.sdk.service.entity.document.DocumentScanQueryResponse;
import io.dingodb.sdk.service.entity.document.DocumentSearchAllRequest;
import io.dingodb.sdk.service.entity.document.DocumentSearchAllResponse;
import io.dingodb.sdk.service.entity.document.DocumentSearchRequest;
import io.dingodb.sdk.service.entity.document.DocumentSearchResponse;
import io.dingodb.sdk.service.entity.document.HelloRequest;
import io.dingodb.sdk.service.entity.document.HelloResponse;
import io.dingodb.sdk.service.entity.store.BackupDataRequest;
import io.dingodb.sdk.service.entity.store.BackupDataResponse;
import io.dingodb.sdk.service.entity.store.RestoreDataRequest;
import io.dingodb.sdk.service.entity.store.RestoreDataResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchGetRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchGetResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusRequest;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusResponse;
import io.dingodb.sdk.service.entity.store.TxnCommitRequest;
import io.dingodb.sdk.service.entity.store.TxnCommitResponse;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeRequest;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeResponse;
import io.dingodb.sdk.service.entity.store.TxnDumpRequest;
import io.dingodb.sdk.service.entity.store.TxnDumpResponse;
import io.dingodb.sdk.service.entity.store.TxnGcRequest;
import io.dingodb.sdk.service.entity.store.TxnGcResponse;
import io.dingodb.sdk.service.entity.store.TxnGetRequest;
import io.dingodb.sdk.service.entity.store.TxnGetResponse;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatRequest;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnPrewriteRequest;
import io.dingodb.sdk.service.entity.store.TxnPrewriteResponse;
import io.dingodb.sdk.service.entity.store.TxnResolveLockRequest;
import io.dingodb.sdk.service.entity.store.TxnResolveLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanLockRequest;
import io.dingodb.sdk.service.entity.store.TxnScanLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanRequest;
import io.dingodb.sdk.service.entity.store.TxnScanResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DocumentServiceDescriptors {
    MethodDescriptor<HelloRequest, HelloResponse> hello = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/Hello", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> helloHandlers = new ServiceCallCycles<>(hello, Hello.logger);

    MethodDescriptor<HelloRequest, HelloResponse> getMemoryInfo = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/GetMemoryInfo", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> getMemoryInfoHandlers = new ServiceCallCycles<>(getMemoryInfo, GetMemoryInfo.logger);

    MethodDescriptor<DocumentAddRequest, DocumentAddResponse> documentAdd = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/DocumentAdd", DocumentAddRequest::new, DocumentAddResponse::new);

    ServiceCallCycles<DocumentAddRequest, DocumentAddResponse> documentAddHandlers = new ServiceCallCycles<>(documentAdd, DocumentAdd.logger);

    MethodDescriptor<DocumentBatchQueryRequest, DocumentBatchQueryResponse> documentBatchQuery = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/DocumentBatchQuery", DocumentBatchQueryRequest::new, DocumentBatchQueryResponse::new);

    ServiceCallCycles<DocumentBatchQueryRequest, DocumentBatchQueryResponse> documentBatchQueryHandlers = new ServiceCallCycles<>(documentBatchQuery, DocumentBatchQuery.logger);

    MethodDescriptor<DocumentSearchRequest, DocumentSearchResponse> documentSearch = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/DocumentSearch", DocumentSearchRequest::new, DocumentSearchResponse::new);

    ServiceCallCycles<DocumentSearchRequest, DocumentSearchResponse> documentSearchHandlers = new ServiceCallCycles<>(documentSearch, DocumentSearch.logger);

    MethodDescriptor<DocumentSearchAllRequest, DocumentSearchAllResponse> documentSearchAll = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/DocumentSearchAll", DocumentSearchAllRequest::new, DocumentSearchAllResponse::new);

    ServiceCallCycles<DocumentSearchAllRequest, DocumentSearchAllResponse> documentSearchAllHandlers = new ServiceCallCycles<>(documentSearchAll, DocumentSearchAll.logger);

    MethodDescriptor<DocumentDeleteRequest, DocumentDeleteResponse> documentDelete = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/DocumentDelete", DocumentDeleteRequest::new, DocumentDeleteResponse::new);

    ServiceCallCycles<DocumentDeleteRequest, DocumentDeleteResponse> documentDeleteHandlers = new ServiceCallCycles<>(documentDelete, DocumentDelete.logger);

    MethodDescriptor<DocumentGetBorderIdRequest, DocumentGetBorderIdResponse> documentGetBorderId = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/DocumentGetBorderId", DocumentGetBorderIdRequest::new, DocumentGetBorderIdResponse::new);

    ServiceCallCycles<DocumentGetBorderIdRequest, DocumentGetBorderIdResponse> documentGetBorderIdHandlers = new ServiceCallCycles<>(documentGetBorderId, DocumentGetBorderId.logger);

    MethodDescriptor<DocumentScanQueryRequest, DocumentScanQueryResponse> documentScanQuery = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/DocumentScanQuery", DocumentScanQueryRequest::new, DocumentScanQueryResponse::new);

    ServiceCallCycles<DocumentScanQueryRequest, DocumentScanQueryResponse> documentScanQueryHandlers = new ServiceCallCycles<>(documentScanQuery, DocumentScanQuery.logger);

    MethodDescriptor<DocumentGetRegionMetricsRequest, DocumentGetRegionMetricsResponse> documentGetRegionMetrics = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/DocumentGetRegionMetrics", DocumentGetRegionMetricsRequest::new, DocumentGetRegionMetricsResponse::new);

    ServiceCallCycles<DocumentGetRegionMetricsRequest, DocumentGetRegionMetricsResponse> documentGetRegionMetricsHandlers = new ServiceCallCycles<>(documentGetRegionMetrics, DocumentGetRegionMetrics.logger);

    MethodDescriptor<DocumentCountRequest, DocumentCountResponse> documentCount = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/DocumentCount", DocumentCountRequest::new, DocumentCountResponse::new);

    ServiceCallCycles<DocumentCountRequest, DocumentCountResponse> documentCountHandlers = new ServiceCallCycles<>(documentCount, DocumentCount.logger);

    MethodDescriptor<TxnGetRequest, TxnGetResponse> txnGet = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnGet", TxnGetRequest::new, TxnGetResponse::new);

    ServiceCallCycles<TxnGetRequest, TxnGetResponse> txnGetHandlers = new ServiceCallCycles<>(txnGet, TxnGet.logger);

    MethodDescriptor<TxnBatchGetRequest, TxnBatchGetResponse> txnBatchGet = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnBatchGet", TxnBatchGetRequest::new, TxnBatchGetResponse::new);

    ServiceCallCycles<TxnBatchGetRequest, TxnBatchGetResponse> txnBatchGetHandlers = new ServiceCallCycles<>(txnBatchGet, TxnBatchGet.logger);

    MethodDescriptor<TxnScanRequest, TxnScanResponse> txnScan = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnScan", TxnScanRequest::new, TxnScanResponse::new);

    ServiceCallCycles<TxnScanRequest, TxnScanResponse> txnScanHandlers = new ServiceCallCycles<>(txnScan, TxnScan.logger);

    MethodDescriptor<TxnScanLockRequest, TxnScanLockResponse> txnScanLock = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnScanLock", TxnScanLockRequest::new, TxnScanLockResponse::new);

    ServiceCallCycles<TxnScanLockRequest, TxnScanLockResponse> txnScanLockHandlers = new ServiceCallCycles<>(txnScanLock, TxnScanLock.logger);

    MethodDescriptor<TxnDumpRequest, TxnDumpResponse> txnDump = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnDump", TxnDumpRequest::new, TxnDumpResponse::new);

    ServiceCallCycles<TxnDumpRequest, TxnDumpResponse> txnDumpHandlers = new ServiceCallCycles<>(txnDump, TxnDump.logger);

    MethodDescriptor<TxnPessimisticLockRequest, TxnPessimisticLockResponse> txnPessimisticLock = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnPessimisticLock", TxnPessimisticLockRequest::new, TxnPessimisticLockResponse::new);

    ServiceCallCycles<TxnPessimisticLockRequest, TxnPessimisticLockResponse> txnPessimisticLockHandlers = new ServiceCallCycles<>(txnPessimisticLock, TxnPessimisticLock.logger);

    MethodDescriptor<TxnPessimisticRollbackRequest, TxnPessimisticRollbackResponse> txnPessimisticRollback = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnPessimisticRollback", TxnPessimisticRollbackRequest::new, TxnPessimisticRollbackResponse::new);

    ServiceCallCycles<TxnPessimisticRollbackRequest, TxnPessimisticRollbackResponse> txnPessimisticRollbackHandlers = new ServiceCallCycles<>(txnPessimisticRollback, TxnPessimisticRollback.logger);

    MethodDescriptor<TxnPrewriteRequest, TxnPrewriteResponse> txnPrewrite = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnPrewrite", TxnPrewriteRequest::new, TxnPrewriteResponse::new);

    ServiceCallCycles<TxnPrewriteRequest, TxnPrewriteResponse> txnPrewriteHandlers = new ServiceCallCycles<>(txnPrewrite, TxnPrewrite.logger);

    MethodDescriptor<TxnCommitRequest, TxnCommitResponse> txnCommit = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnCommit", TxnCommitRequest::new, TxnCommitResponse::new);

    ServiceCallCycles<TxnCommitRequest, TxnCommitResponse> txnCommitHandlers = new ServiceCallCycles<>(txnCommit, TxnCommit.logger);

    MethodDescriptor<TxnCheckTxnStatusRequest, TxnCheckTxnStatusResponse> txnCheckTxnStatus = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnCheckTxnStatus", TxnCheckTxnStatusRequest::new, TxnCheckTxnStatusResponse::new);

    ServiceCallCycles<TxnCheckTxnStatusRequest, TxnCheckTxnStatusResponse> txnCheckTxnStatusHandlers = new ServiceCallCycles<>(txnCheckTxnStatus, TxnCheckTxnStatus.logger);

    MethodDescriptor<TxnResolveLockRequest, TxnResolveLockResponse> txnResolveLock = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnResolveLock", TxnResolveLockRequest::new, TxnResolveLockResponse::new);

    ServiceCallCycles<TxnResolveLockRequest, TxnResolveLockResponse> txnResolveLockHandlers = new ServiceCallCycles<>(txnResolveLock, TxnResolveLock.logger);

    MethodDescriptor<TxnBatchRollbackRequest, TxnBatchRollbackResponse> txnBatchRollback = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnBatchRollback", TxnBatchRollbackRequest::new, TxnBatchRollbackResponse::new);

    ServiceCallCycles<TxnBatchRollbackRequest, TxnBatchRollbackResponse> txnBatchRollbackHandlers = new ServiceCallCycles<>(txnBatchRollback, TxnBatchRollback.logger);

    MethodDescriptor<TxnHeartBeatRequest, TxnHeartBeatResponse> txnHeartBeat = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnHeartBeat", TxnHeartBeatRequest::new, TxnHeartBeatResponse::new);

    ServiceCallCycles<TxnHeartBeatRequest, TxnHeartBeatResponse> txnHeartBeatHandlers = new ServiceCallCycles<>(txnHeartBeat, TxnHeartBeat.logger);

    MethodDescriptor<TxnGcRequest, TxnGcResponse> txnGc = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnGc", TxnGcRequest::new, TxnGcResponse::new);

    ServiceCallCycles<TxnGcRequest, TxnGcResponse> txnGcHandlers = new ServiceCallCycles<>(txnGc, TxnGc.logger);

    MethodDescriptor<TxnDeleteRangeRequest, TxnDeleteRangeResponse> txnDeleteRange = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/TxnDeleteRange", TxnDeleteRangeRequest::new, TxnDeleteRangeResponse::new);

    ServiceCallCycles<TxnDeleteRangeRequest, TxnDeleteRangeResponse> txnDeleteRangeHandlers = new ServiceCallCycles<>(txnDeleteRange, TxnDeleteRange.logger);

    MethodDescriptor<BackupDataRequest, BackupDataResponse> backupData = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/BackupData", BackupDataRequest::new, BackupDataResponse::new);

    ServiceCallCycles<BackupDataRequest, BackupDataResponse> backupDataHandlers = new ServiceCallCycles<>(backupData, BackupData.logger);

    MethodDescriptor<RestoreDataRequest, RestoreDataResponse> restoreData = ServiceMethodBuilder.buildUnary("dingodb.pb.document.DocumentService/RestoreData", RestoreDataRequest::new, RestoreDataResponse::new);

    ServiceCallCycles<RestoreDataRequest, RestoreDataResponse> restoreDataHandlers = new ServiceCallCycles<>(restoreData, RestoreData.logger);

    final class Hello {
        public static final Logger logger = LoggerFactory.getLogger(Hello.class);
    }

    final class GetMemoryInfo {
        public static final Logger logger = LoggerFactory.getLogger(GetMemoryInfo.class);
    }

    final class DocumentAdd {
        public static final Logger logger = LoggerFactory.getLogger(DocumentAdd.class);
    }

    final class DocumentBatchQuery {
        public static final Logger logger = LoggerFactory.getLogger(DocumentBatchQuery.class);
    }

    final class DocumentSearch {
        public static final Logger logger = LoggerFactory.getLogger(DocumentSearch.class);
    }

    final class DocumentSearchAll {
        public static final Logger logger = LoggerFactory.getLogger(DocumentSearchAll.class);
    }

    final class DocumentDelete {
        public static final Logger logger = LoggerFactory.getLogger(DocumentDelete.class);
    }

    final class DocumentGetBorderId {
        public static final Logger logger = LoggerFactory.getLogger(DocumentGetBorderId.class);
    }

    final class DocumentScanQuery {
        public static final Logger logger = LoggerFactory.getLogger(DocumentScanQuery.class);
    }

    final class DocumentGetRegionMetrics {
        public static final Logger logger = LoggerFactory.getLogger(DocumentGetRegionMetrics.class);
    }

    final class DocumentCount {
        public static final Logger logger = LoggerFactory.getLogger(DocumentCount.class);
    }

    final class TxnGet {
        public static final Logger logger = LoggerFactory.getLogger(TxnGet.class);
    }

    final class TxnBatchGet {
        public static final Logger logger = LoggerFactory.getLogger(TxnBatchGet.class);
    }

    final class TxnScan {
        public static final Logger logger = LoggerFactory.getLogger(TxnScan.class);
    }

    final class TxnScanLock {
        public static final Logger logger = LoggerFactory.getLogger(TxnScanLock.class);
    }

    final class TxnDump {
        public static final Logger logger = LoggerFactory.getLogger(TxnDump.class);
    }

    final class TxnPessimisticLock {
        public static final Logger logger = LoggerFactory.getLogger(TxnPessimisticLock.class);
    }

    final class TxnPessimisticRollback {
        public static final Logger logger = LoggerFactory.getLogger(TxnPessimisticRollback.class);
    }

    final class TxnPrewrite {
        public static final Logger logger = LoggerFactory.getLogger(TxnPrewrite.class);
    }

    final class TxnCommit {
        public static final Logger logger = LoggerFactory.getLogger(TxnCommit.class);
    }

    final class TxnCheckTxnStatus {
        public static final Logger logger = LoggerFactory.getLogger(TxnCheckTxnStatus.class);
    }

    final class TxnResolveLock {
        public static final Logger logger = LoggerFactory.getLogger(TxnResolveLock.class);
    }

    final class TxnBatchRollback {
        public static final Logger logger = LoggerFactory.getLogger(TxnBatchRollback.class);
    }

    final class TxnHeartBeat {
        public static final Logger logger = LoggerFactory.getLogger(TxnHeartBeat.class);
    }

    final class TxnGc {
        public static final Logger logger = LoggerFactory.getLogger(TxnGc.class);
    }

    final class TxnDeleteRange {
        public static final Logger logger = LoggerFactory.getLogger(TxnDeleteRange.class);
    }

    final class BackupData {
        public static final Logger logger = LoggerFactory.getLogger(BackupData.class);
    }

    final class RestoreData {
        public static final Logger logger = LoggerFactory.getLogger(RestoreData.class);
    }
}
