package io.dingodb.sdk.service.desc.diskann;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.diskann.VectorBuildRequest;
import io.dingodb.sdk.service.entity.diskann.VectorBuildResponse;
import io.dingodb.sdk.service.entity.diskann.VectorCloseRequest;
import io.dingodb.sdk.service.entity.diskann.VectorCloseResponse;
import io.dingodb.sdk.service.entity.diskann.VectorCountRequest;
import io.dingodb.sdk.service.entity.diskann.VectorCountResponse;
import io.dingodb.sdk.service.entity.diskann.VectorDestroyRequest;
import io.dingodb.sdk.service.entity.diskann.VectorDestroyResponse;
import io.dingodb.sdk.service.entity.diskann.VectorDumpAllRequest;
import io.dingodb.sdk.service.entity.diskann.VectorDumpAllResponse;
import io.dingodb.sdk.service.entity.diskann.VectorDumpRequest;
import io.dingodb.sdk.service.entity.diskann.VectorDumpResponse;
import io.dingodb.sdk.service.entity.diskann.VectorLoadRequest;
import io.dingodb.sdk.service.entity.diskann.VectorLoadResponse;
import io.dingodb.sdk.service.entity.diskann.VectorNewRequest;
import io.dingodb.sdk.service.entity.diskann.VectorNewResponse;
import io.dingodb.sdk.service.entity.diskann.VectorPushDataRequest;
import io.dingodb.sdk.service.entity.diskann.VectorPushDataResponse;
import io.dingodb.sdk.service.entity.diskann.VectorResetRequest;
import io.dingodb.sdk.service.entity.diskann.VectorResetResponse;
import io.dingodb.sdk.service.entity.diskann.VectorSearchRequest;
import io.dingodb.sdk.service.entity.diskann.VectorSearchResponse;
import io.dingodb.sdk.service.entity.diskann.VectorSetImportTooManyRequest;
import io.dingodb.sdk.service.entity.diskann.VectorSetImportTooManyResponse;
import io.dingodb.sdk.service.entity.diskann.VectorSetNoDataRequest;
import io.dingodb.sdk.service.entity.diskann.VectorSetNoDataResponse;
import io.dingodb.sdk.service.entity.diskann.VectorStatusRequest;
import io.dingodb.sdk.service.entity.diskann.VectorStatusResponse;
import io.dingodb.sdk.service.entity.diskann.VectorTryLoadRequest;
import io.dingodb.sdk.service.entity.diskann.VectorTryLoadResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DiskAnnServiceDescriptors {
    MethodDescriptor<VectorNewRequest, VectorNewResponse> vectorNew = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorNew", VectorNewRequest::new, VectorNewResponse::new);

    ServiceCallCycles<VectorNewRequest, VectorNewResponse> vectorNewHandlers = new ServiceCallCycles<>(vectorNew, VectorNew.logger);

    MethodDescriptor<VectorPushDataRequest, VectorPushDataResponse> vectorPushData = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorPushData", VectorPushDataRequest::new, VectorPushDataResponse::new);

    ServiceCallCycles<VectorPushDataRequest, VectorPushDataResponse> vectorPushDataHandlers = new ServiceCallCycles<>(vectorPushData, VectorPushData.logger);

    MethodDescriptor<VectorBuildRequest, VectorBuildResponse> vectorBuild = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorBuild", VectorBuildRequest::new, VectorBuildResponse::new);

    ServiceCallCycles<VectorBuildRequest, VectorBuildResponse> vectorBuildHandlers = new ServiceCallCycles<>(vectorBuild, VectorBuild.logger);

    MethodDescriptor<VectorLoadRequest, VectorLoadResponse> vectorLoad = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorLoad", VectorLoadRequest::new, VectorLoadResponse::new);

    ServiceCallCycles<VectorLoadRequest, VectorLoadResponse> vectorLoadHandlers = new ServiceCallCycles<>(vectorLoad, VectorLoad.logger);

    MethodDescriptor<VectorTryLoadRequest, VectorTryLoadResponse> vectorTryLoad = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorTryLoad", VectorTryLoadRequest::new, VectorTryLoadResponse::new);

    ServiceCallCycles<VectorTryLoadRequest, VectorTryLoadResponse> vectorTryLoadHandlers = new ServiceCallCycles<>(vectorTryLoad, VectorTryLoad.logger);

    MethodDescriptor<VectorSearchRequest, VectorSearchResponse> vectorSearch = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorSearch", VectorSearchRequest::new, VectorSearchResponse::new);

    ServiceCallCycles<VectorSearchRequest, VectorSearchResponse> vectorSearchHandlers = new ServiceCallCycles<>(vectorSearch, VectorSearch.logger);

    MethodDescriptor<VectorResetRequest, VectorResetResponse> vectorReset = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorReset", VectorResetRequest::new, VectorResetResponse::new);

    ServiceCallCycles<VectorResetRequest, VectorResetResponse> vectorResetHandlers = new ServiceCallCycles<>(vectorReset, VectorReset.logger);

    MethodDescriptor<VectorCloseRequest, VectorCloseResponse> vectorClose = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorClose", VectorCloseRequest::new, VectorCloseResponse::new);

    ServiceCallCycles<VectorCloseRequest, VectorCloseResponse> vectorCloseHandlers = new ServiceCallCycles<>(vectorClose, VectorClose.logger);

    MethodDescriptor<VectorDestroyRequest, VectorDestroyResponse> vectorDestroy = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorDestroy", VectorDestroyRequest::new, VectorDestroyResponse::new);

    ServiceCallCycles<VectorDestroyRequest, VectorDestroyResponse> vectorDestroyHandlers = new ServiceCallCycles<>(vectorDestroy, VectorDestroy.logger);

    MethodDescriptor<VectorStatusRequest, VectorStatusResponse> vectorStatus = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorStatus", VectorStatusRequest::new, VectorStatusResponse::new);

    ServiceCallCycles<VectorStatusRequest, VectorStatusResponse> vectorStatusHandlers = new ServiceCallCycles<>(vectorStatus, VectorStatus.logger);

    MethodDescriptor<VectorCountRequest, VectorCountResponse> vectorCount = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorCount", VectorCountRequest::new, VectorCountResponse::new);

    ServiceCallCycles<VectorCountRequest, VectorCountResponse> vectorCountHandlers = new ServiceCallCycles<>(vectorCount, VectorCount.logger);

    MethodDescriptor<VectorSetNoDataRequest, VectorSetNoDataResponse> vectorSetNoData = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorSetNoData", VectorSetNoDataRequest::new, VectorSetNoDataResponse::new);

    ServiceCallCycles<VectorSetNoDataRequest, VectorSetNoDataResponse> vectorSetNoDataHandlers = new ServiceCallCycles<>(vectorSetNoData, VectorSetNoData.logger);

    MethodDescriptor<VectorSetImportTooManyRequest, VectorSetImportTooManyResponse> vectorSetImportTooMany = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorSetImportTooMany", VectorSetImportTooManyRequest::new, VectorSetImportTooManyResponse::new);

    ServiceCallCycles<VectorSetImportTooManyRequest, VectorSetImportTooManyResponse> vectorSetImportTooManyHandlers = new ServiceCallCycles<>(vectorSetImportTooMany, VectorSetImportTooMany.logger);

    MethodDescriptor<VectorDumpRequest, VectorDumpResponse> vectorDump = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorDump", VectorDumpRequest::new, VectorDumpResponse::new);

    ServiceCallCycles<VectorDumpRequest, VectorDumpResponse> vectorDumpHandlers = new ServiceCallCycles<>(vectorDump, VectorDump.logger);

    MethodDescriptor<VectorDumpAllRequest, VectorDumpAllResponse> vectorDumpAll = ServiceMethodBuilder.buildUnary("dingodb.pb.diskann.DiskAnnService/VectorDumpAll", VectorDumpAllRequest::new, VectorDumpAllResponse::new);

    ServiceCallCycles<VectorDumpAllRequest, VectorDumpAllResponse> vectorDumpAllHandlers = new ServiceCallCycles<>(vectorDumpAll, VectorDumpAll.logger);

    final class VectorNew {
        public static final Logger logger = LoggerFactory.getLogger(VectorNew.class);
    }

    final class VectorPushData {
        public static final Logger logger = LoggerFactory.getLogger(VectorPushData.class);
    }

    final class VectorBuild {
        public static final Logger logger = LoggerFactory.getLogger(VectorBuild.class);
    }

    final class VectorLoad {
        public static final Logger logger = LoggerFactory.getLogger(VectorLoad.class);
    }

    final class VectorTryLoad {
        public static final Logger logger = LoggerFactory.getLogger(VectorTryLoad.class);
    }

    final class VectorSearch {
        public static final Logger logger = LoggerFactory.getLogger(VectorSearch.class);
    }

    final class VectorReset {
        public static final Logger logger = LoggerFactory.getLogger(VectorReset.class);
    }

    final class VectorClose {
        public static final Logger logger = LoggerFactory.getLogger(VectorClose.class);
    }

    final class VectorDestroy {
        public static final Logger logger = LoggerFactory.getLogger(VectorDestroy.class);
    }

    final class VectorStatus {
        public static final Logger logger = LoggerFactory.getLogger(VectorStatus.class);
    }

    final class VectorCount {
        public static final Logger logger = LoggerFactory.getLogger(VectorCount.class);
    }

    final class VectorSetNoData {
        public static final Logger logger = LoggerFactory.getLogger(VectorSetNoData.class);
    }

    final class VectorSetImportTooMany {
        public static final Logger logger = LoggerFactory.getLogger(VectorSetImportTooMany.class);
    }

    final class VectorDump {
        public static final Logger logger = LoggerFactory.getLogger(VectorDump.class);
    }

    final class VectorDumpAll {
        public static final Logger logger = LoggerFactory.getLogger(VectorDumpAll.class);
    }
}
